// MapDataTypes.java
//

package org.biomoby.shared.datatypes;

public class MapDataTypes
    extends MapPrimitiveDataTypes
    implements MapDataTypesIfc {

    /*********************************************************************
     * Always call this method before start using this class. This is
     * because the class puts data types definitions into a static
     * structure that inherits from its superclass in a static
     * initializer - and that would not happen before any method is
     * called. This is what Java language specification says about it: <p>
     *
     * This static initialization occurs automatically when the class
     * containing the variable is first accessed. Here, "first
     * accessed" is defined to be the first time one of the following
     * events occurs:
     *
     * <ol>
     *
     * <li> An instance of the class is created via a
     * constructor. (This cannot be a case for this particular class
     * because it does not have any cobstructor.)
     *
     * <li> A static method that is defined in the class (not
     * inherited) is called. (This is our case here!)
     *
     * <li> A static variable that is declared in the class (not
     * inherited) is assigned or otherwise accessed. This does not
     * include the static initializer, which occurs at compile time.
     *
     * </ol>
     * 
     ********************************************************************/
    public void makeSureItIsLoaded() {}

    static {
