/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.LSIDWebService;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.soap.Name;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;

public class DataWebService
extends LSIDWebService {
    public SOAPBodyElement[] getData(SOAPBodyElement[] bodyElements) throws AxisFault {
        InputStream data = null;
        try {
            LSID lsid = this.getLSID(bodyElements[0]);
            LSIDRequestContext ctx = this.getRequestContext(lsid);
            ServiceRegistry reg = this.getServiceRegistry("dataserviceImplRegistry");
            LSIDDataService service = (LSIDDataService)reg.lookupService(lsid);
            if (service == null) {
                throw new LSIDServerException(201, "Unknown lsid: " + lsid);
            }
            data = service.getData(ctx);
            this.addAttachment(data);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getDataResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/DataServiceSOAPBindings");
            SOAPBodyElement[] sOAPBodyElementArray = new SOAPBodyElement[]{ret};
            return sOAPBodyElementArray;
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] getDataByRange(SOAPBodyElement[] bodyElements) throws AxisFault {
        InputStream data = null;
        try {
            LSID lsid = this.getLSID(bodyElements[0]);
            int start = this.getRangeValue(bodyElements[0], "start");
            int length = this.getRangeValue(bodyElements[0], "length");
            LSIDRequestContext ctx = this.getRequestContext(lsid);
            ServiceRegistry reg = this.getServiceRegistry("dataserviceImplRegistry");
            LSIDDataService service = (LSIDDataService)reg.lookupService(lsid);
            data = service.getDataByRange(ctx, start, length);
            this.addAttachment(data);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getDataByRangeResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/DataServiceSOAPBindings");
            SOAPBodyElement[] sOAPBodyElementArray = new SOAPBodyElement[]{ret};
            return sOAPBodyElementArray;
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    private int getRangeValue(SOAPBodyElement bodyElt, String rangePart) throws AxisFault {
        Iterator it = bodyElt.getChildElements((Name)new PrefixedQName(null, rangePart, null));
        if (!it.hasNext()) {
            throw AxisFaultBuilder.createFault(712, "Must specify " + rangePart + " parameter");
        }
        MessageElement elt = (MessageElement)it.next();
        String eltValue = elt.getValue();
        try {
            return Integer.parseInt(eltValue);
        }
        catch (NumberFormatException e) {
            throw AxisFaultBuilder.createFault(712, "Bad range parameter: " + eltValue);
        }
    }
}

