/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.metadata.rdf;

import com.ibm.lsid.LSID;

public class Resource {
    private String uri;
    private String namespaceURI;
    private String name;

    public Resource(String uri) {
        this.uri = uri;
        for (int i = uri.length() - 1; i >= 0; --i) {
            if (uri.charAt(i) == ':') {
                this.namespaceURI = uri.substring(0, i + 1);
                this.name = uri.substring(i + 1);
                break;
            }
            if (uri.charAt(i) != '#') continue;
            this.namespaceURI = uri.substring(0, i + 1);
            this.name = uri.substring(i + 1);
            break;
        }
    }

    public Resource(String namespaceURI, String name) {
        this.namespaceURI = namespaceURI;
        this.name = name;
        this.uri = namespaceURI + ":" + name;
    }

    public Resource(LSID lsid) {
        this(lsid.getLsid());
    }

    public boolean equals(Resource r) {
        return this.uri.equals(r.uri);
    }

    public String toString() {
        return "<" + this.uri + ">";
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }
}

