/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class TXTRecord
extends Record {
    private static TXTRecord member = new TXTRecord();
    private List strings;

    private TXTRecord() {
    }

    private TXTRecord(Name name, short dclass, int ttl) {
        super(name, (short)16, dclass, ttl);
    }

    static TXTRecord getMember() {
        return member;
    }

    public TXTRecord(Name name, short dclass, int ttl, List strings) {
        this(name, dclass, ttl);
        if (strings == null) {
            throw new IllegalArgumentException("TXTRecord: strings must not be null");
        }
        this.strings = strings;
    }

    public TXTRecord(Name name, short dclass, int ttl, String string) {
        this(name, dclass, ttl);
        this.strings = new ArrayList();
        this.strings.add(string);
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        TXTRecord rec = new TXTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        int count = 0;
        rec.strings = new ArrayList();
        while (count < length) {
            byte len = in.readByte();
            byte[] b = new byte[len];
            in.read(b);
            count += len + 1;
            rec.strings.add(new String(b));
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        TXTRecord rec = new TXTRecord(name, dclass, ttl);
        rec.strings = new ArrayList();
        while (st.hasMoreTokens()) {
            rec.strings.add(st.nextToken());
        }
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.strings != null) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                sb.append("\"");
                sb.append(s);
                sb.append("\"");
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public List getStrings() {
        return this.strings;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.strings == null) {
            return;
        }
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            out.writeString(s);
        }
    }
}

