/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xbill.DNS.TextParseException;

public class Inet6Address {
    private byte[] data;

    public Inet6Address(byte[] data) throws IOException {
        if (data.length != 16) {
            throw new IOException("An Inet6Address is 128 bits");
        }
        this.data = data;
    }

    public Inet6Address(int bits, byte[] data) throws IOException {
        if (data.length > 16) {
            throw new IOException("An Inet6Address is only 128 bits");
        }
        int bytes = (bits + 7) / 8;
        this.data = new byte[16];
        System.arraycopy(data, 0, this.data, 16 - bytes, bytes);
    }

    public Inet6Address(String s) throws TextParseException {
        boolean parsev4 = false;
        ArrayList<String> l = new ArrayList<String>();
        int range = -1;
        this.data = new byte[16];
        StringTokenizer st = new StringTokenizer(s, ":", true);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        l.add("");
        l.add("");
        String[] tokens = l.toArray(new String[l.size()]);
        int i = 0;
        int j = 0;
        while (i < tokens.length - 2) {
            if (tokens[i].equals(":")) {
                if (tokens[i + 1].equals(":")) {
                    if (tokens[i + 2].equals(":") || range > 0) {
                        throw new TextParseException("Invalid IPv6 address");
                    }
                    range = j;
                    if (tokens[i + 2].equals("")) break;
                    ++i;
                }
                ++i;
            }
            if (tokens[i].indexOf(46) >= 0) {
                parsev4 = true;
                if (tokens[i + 1].equals("")) break;
                throw new TextParseException("Invalid IPv6 address");
            }
            try {
                int x = Integer.parseInt(tokens[i], 16);
                if (x > 65535) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                if (j > 14) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                this.data[j++] = (byte)(x >>> 8);
                this.data[j++] = (byte)(x & 0xFF);
            }
            catch (NumberFormatException e) {
                throw new TextParseException("Invalid IPv6 address");
            }
            ++i;
        }
        if (parsev4) {
            st = new StringTokenizer(tokens[i], ".");
            int k = 0;
            while (k < 4) {
                if (!st.hasMoreTokens()) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                String token = st.nextToken();
                try {
                    this.data[j++] = (byte)Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                ++k;
            }
        }
        if (range >= 0) {
            int left = 16 - j;
            int k = 0;
            while (k < j) {
                this.data[15 - k] = this.data[15 - k - left];
                ++k;
            }
            int k2 = range;
            while (k2 < range + left) {
                this.data[k2] = 0;
                ++k2;
            }
        } else if (j < 16) {
            throw new TextParseException("Invalid IPv6 address");
        }
    }

    public byte[] toBytes() {
        return this.data;
    }

    public String toString() {
        int[] labels = new int[8];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        boolean j = false;
        while (i < 8) {
            labels[i] = ((this.data[2 * i] & 0xFF) << 8) + (this.data[2 * i + 1] & 0xFF);
            ++i;
        }
        int start = -1;
        int length = -1;
        int tstart = -1;
        int tlength = -1;
        boolean inzero = false;
        int i2 = 0;
        boolean j2 = false;
        while (i2 < 8) {
            if (!inzero) {
                if (labels[i2] == 0) {
                    tstart = i2;
                    tlength = 0;
                    inzero = true;
                }
            } else if (labels[i2] == 0) {
                ++tlength;
            } else {
                inzero = false;
                if (tlength > length) {
                    start = tstart;
                    length = tlength;
                }
                tlength = -1;
            }
            ++i2;
        }
        if (tlength > length) {
            start = tstart;
            length = tlength;
        }
        if (start == -1) {
            int i3 = 0;
            while (i3 < 8) {
                sb.append(Integer.toHexString(labels[i3]).toUpperCase());
                if (i3 != 7) {
                    sb.append(":");
                }
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < start) {
                sb.append(Integer.toHexString(labels[i4]).toUpperCase());
                sb.append(":");
                ++i4;
            }
            if (start == 0) {
                sb.append(":");
            }
            sb.append(":");
            int i5 = start + length + 1;
            while (i5 < 8) {
                sb.append(Integer.toHexString(labels[i5]).toUpperCase());
                if (i5 != 7) {
                    sb.append(":");
                }
                ++i5;
            }
        }
        return sb.toString();
    }
}

