/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.Task.WorkerThread;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private static int uniqueID = 0;
    private static final Random random = new Random();
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] servers = FindServer.servers();
        if (servers != null) {
            int i = 0;
            while (i < servers.length) {
                SimpleResolver r = new SimpleResolver(servers[i]);
                r.setTimeout(5);
                this.resolvers.add(r);
                ++i;
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] servers) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < servers.length) {
            SimpleResolver r = new SimpleResolver(servers[i]);
            r.setTimeout(5);
            this.resolvers.add(r);
            ++i;
        }
    }

    public ExtendedResolver(Resolver[] res) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < res.length) {
            this.resolvers.add(res[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTo(Message query, Receiver receiver, Map idMap, int r) {
        Resolver res = (Resolver)this.resolvers.get(r);
        Map map = idMap;
        synchronized (map) {
            Object id = res.sendAsync(query, receiver);
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: sending id " + id + " to resolver " + r);
            }
            idMap.put(id, new Integer(r));
        }
    }

    public void setPort(int port) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setPort(port);
            ++i;
        }
    }

    public void setTCP(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTCP(flag);
            ++i;
        }
    }

    public void setIgnoreTruncation(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(flag);
            ++i;
        }
    }

    public void setEDNS(int level) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setEDNS(level);
            ++i;
        }
    }

    public void setTSIGKey(Name name, byte[] key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    public void setTSIGKey(String name, String key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    public void setTSIGKey(String key) throws UnknownHostException {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(key);
            ++i;
        }
    }

    public void setTimeout(int secs) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTimeout(secs);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(Message query) throws IOException {
        Message best = null;
        IOException bestException = null;
        boolean[] invalid = new boolean[this.resolvers.size()];
        byte[] sent = new byte[this.resolvers.size()];
        byte[] recvd = new byte[this.resolvers.size()];
        LinkedList queue = new LinkedList();
        HashMap idMap = new HashMap();
        Receiver receiver = new Receiver(queue, idMap);
        while (true) {
            Message m;
            QElement qe;
            boolean waiting = false;
            LinkedList linkedList = queue;
            synchronized (linkedList) {
                int r;
                int start;
                int nresolvers = this.resolvers.size();
                if (this.loadBalance) {
                    start = this.lbStart % nresolvers;
                    if (this.lbStart > nresolvers) {
                        this.lbStart %= nresolvers;
                    }
                } else {
                    start = 0;
                }
                int i = start;
                while (i < nresolvers + start) {
                    r = i % nresolvers;
                    if (!invalid[r] && sent[r] == recvd[r] && sent[r] < this.retries) {
                        this.sendTo(query, receiver, idMap, r);
                        int n = r;
                        sent[n] = (byte)(sent[n] + 1);
                        waiting = true;
                        break;
                    }
                    if (recvd[r] < sent[r]) {
                        waiting = true;
                    }
                    ++i;
                }
                if (!waiting) {
                    break;
                }
                try {
                    queue.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (queue.size() == 0) {
                    continue;
                }
                qe = (QElement)queue.getFirst();
                queue.remove(qe);
                m = qe.obj instanceof Message ? (Message)qe.obj : null;
                int n = r = qe.res;
                recvd[n] = (byte)(recvd[n] + 1);
            }
            if (m == null) {
                if (qe.obj instanceof RuntimeException) {
                    throw (RuntimeException)qe.obj;
                }
                IOException e = (IOException)qe.obj;
                if (!(e instanceof InterruptedIOException)) {
                    invalid[r] = true;
                }
                if (bestException != null) continue;
                bestException = e;
                continue;
            }
            short rcode = m.getRcode();
            if (rcode == 0 || rcode == 3) {
                return m;
            }
            if (best == null) {
                best = m;
            }
            invalid[r] = true;
        }
        if (best != null) {
            return best;
        }
        throw bestException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        ExtendedResolver extendedResolver = this;
        synchronized (extendedResolver) {
            id = new Integer(uniqueID++);
        }
        Record question = query.getQuestion();
        if (question != null) {
            String qname = question.getName().toString();
        } else {
            String qname = "(none)";
        }
        String name = this.getClass() + ": " + query.getQuestion().getName();
        WorkerThread.assignThread(new ResolveThread(this, query, id, listener), name);
        return id;
    }

    public Resolver getResolver(int i) {
        if (i < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(i);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver r) {
        this.resolvers.add(r);
    }

    public void deleteResolver(Resolver r) {
        this.resolvers.remove(r);
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    class Receiver
    implements ResolverListener {
        LinkedList queue;
        Map idMap;

        public Receiver(LinkedList queue, Map idMap) {
            this.queue = queue;
            this.idMap = idMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueInfo(Object id, Object obj) {
            int r;
            Map map = this.idMap;
            synchronized (map) {
                Integer R = (Integer)this.idMap.get(id);
                if (R == null) {
                    return;
                }
                r = R;
                this.idMap.remove(id);
            }
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                QElement qe = new QElement(obj, r);
                this.queue.add(qe);
                this.queue.notify();
            }
        }

        public void receiveMessage(Object id, Message m) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message " + id);
            }
            this.enqueueInfo(id, m);
        }

        public void handleException(Object id, Exception e) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: exception on message " + id);
            }
            this.enqueueInfo(id, e);
        }
    }

    class QElement {
        Object obj;
        int res;

        public QElement(Object obj, int res) {
            this.obj = obj;
            this.res = res;
        }
    }
}

