/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base16;

public class DSRecord
extends Record {
    public static final byte SHA1_DIGEST_ID = 1;
    private static DSRecord member = new DSRecord();
    private int footprint = -1;
    private byte alg;
    private byte digestid = 1;
    private byte[] digest;

    private DSRecord() {
    }

    private DSRecord(Name name, short dclass, int ttl) {
        super(name, (short)43, dclass, ttl);
    }

    static DSRecord getMember() {
        return member;
    }

    public DSRecord(Name name, short dclass, int ttl, int footprint, int alg, int digestid, byte[] digest) {
        this(name, dclass, ttl);
        this.footprint = footprint;
        this.alg = (byte)alg;
        this.digestid = (byte)digestid;
        this.digest = digest;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        DSRecord rec = new DSRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.footprint = in.readShort() & 0xFFFF;
        rec.alg = in.readByte();
        rec.digestid = in.readByte();
        if (length > 4) {
            rec.digest = new byte[length - 4];
            in.read(rec.digest);
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        DSRecord rec = new DSRecord(name, dclass, ttl);
        rec.footprint = Integer.decode(st.nextToken());
        rec.alg = (byte)Integer.parseInt(st.nextToken());
        rec.digestid = (byte)Integer.parseInt(st.nextToken());
        rec.digest = base16.fromString(st.remainingTokens());
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.footprint & 0xFFFF);
        sb.append(" ");
        sb.append(this.alg & 0xFF);
        sb.append(" ");
        sb.append(this.digestid & 0xFF);
        if (this.digest != null) {
            sb.append(" ");
            sb.append(base16.toString(this.digest));
        }
        return sb.toString();
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte getDigestID() {
        return this.digestid;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public short getFootprint() {
        return (short)this.footprint;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        out.writeShort(this.footprint);
        out.writeByte(this.alg);
        out.writeByte(this.digestid);
        if (this.digest != null) {
            out.writeArray(this.digest);
        }
    }
}

