/*
 * Decompiled with CFR 0.152.
 */
package org.cgiar.icis.pedigree;

import java.awt.Color;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.cgiar.icis.pedigree.ExitListener;

public class WindowUtilities {
    public static void setNativeLookAndFeel() throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            throw new Exception("ERROR: Unable to set Native Look & Feel.", ex);
        }
    }

    public static void setJavaLookAndFeel() throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception ex) {
            throw new Exception("ERROR: Unable to set Java Look & Feel.", ex);
        }
    }

    public static void setMotifLookAndFeel() throws Exception {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception ex) {
            throw new Exception("ERROR: Unable to set Motif Look & Feel.", ex);
        }
    }

    public static JFrame openInJFrame(Container content, int width, int height, String title, Color bgColor) {
        JFrame jframe = new JFrame(title);
        jframe.setBackground(bgColor);
        content.setBackground(bgColor);
        jframe.setSize(width, height);
        jframe.setContentPane(content);
        jframe.addWindowListener(new ExitListener());
        jframe.setVisible(true);
        return jframe;
    }

    public static JFrame openInJFrame(Container content, int width, int height, String title) {
        return WindowUtilities.openInJFrame(content, width, height, title, Color.white);
    }

    public static JFrame openInJFrame(Container content, int width, int height) {
        return WindowUtilities.openInJFrame(content, width, height, content.getClass().getName(), Color.white);
    }
}

