/*
 * Decompiled with CFR 0.152.
 */
package org.cgiar.icis.pedigree;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.cgiar.icis.pedigree.PedigreeTreeNodeObject;
import org.cgiar.icis.pedigree.XmlJTreeHandler;
import org.cgiar.icis.pedigree.XmlJTreeParser;

public class PedigreeTreeComponent
extends JPanel
implements TreeSelectionListener {
    protected JTree pedigreeTree = null;
    private JScrollPane pedigreeTreeScroll = null;
    private JTextField germplasmIdText = null;
    private JTextField germplasmNameText = null;
    private JTextField methodText = null;
    private JTextField dateText = null;
    private JTextField locationText = null;
    private JTextField countryText = null;
    private JTextField referenceText = null;
    private JLabel parent1Label = null;
    private JTextField parent1Text = null;
    private JLabel parent2Label = null;
    private JTextField parent2Text = null;
    private String fontName = "Arial Unicode MS";
    private final int fontType = 0;
    private int fontSize = 12;
    private Font font = null;
    private int frameWidth;

    public PedigreeTreeComponent(int frameWidth) throws Exception {
        this.frameWidth = frameWidth;
        this.initGmsSearchDisplay();
    }

    public void initGmsSearchDisplay() throws Exception {
        try {
            this.font = new Font(this.fontName, this.fontType, this.fontSize);
            UIManager.put("ToolTip.font", this.font);
            this.setLayout(new GridBagLayout());
            TitledBorder titledBorder = new TitledBorder("");
            titledBorder.setTitleFont(this.font);
            this.setBorder(titledBorder);
            JPanel panelPedigreeTree = new JPanel(new GridBagLayout());
            titledBorder = new TitledBorder("Pedigree Tree");
            titledBorder.setTitleFont(this.font);
            panelPedigreeTree.setBorder(titledBorder);
            this.pedigreeTree = new JTree();
            this.pedigreeTree.setFont(this.font);
            this.pedigreeTree.setModel(null);
            this.pedigreeTree.addTreeSelectionListener(this);
            this.pedigreeTreeScroll = new JScrollPane(this.pedigreeTree);
            PedigreeTreeComponent.addComp(panelPedigreeTree, this.pedigreeTreeScroll, 0, 0, 1, 1, 1, 18, 1.0, 1.0);
            PedigreeTreeComponent.addComp(this, panelPedigreeTree, 0, 0, 1, 1, 1, 18, 1.0, 1.0);
            JPanel panelGermplasmItemInfo = new JPanel();
            panelGermplasmItemInfo.setLayout(new BoxLayout(panelGermplasmItemInfo, 1));
            titledBorder = new TitledBorder("Germplasm Information");
            titledBorder.setTitleFont(this.font);
            panelGermplasmItemInfo.setBorder(titledBorder);
            JLabel germplasmIdLabel = new JLabel("GID");
            germplasmIdLabel.setFont(this.font);
            this.germplasmIdText = new JTextField("", 6);
            this.germplasmIdText.setFont(this.font);
            this.germplasmIdText.setEditable(false);
            JLabel germplasmNameLabel = new JLabel("Name");
            germplasmNameLabel.setFont(this.font);
            this.germplasmNameText = new JTextField("", 25);
            this.germplasmNameText.setFont(this.font);
            this.germplasmNameText.setEditable(false);
            JLabel methodLabel = new JLabel("Method");
            methodLabel.setFont(this.font);
            this.methodText = new JTextField("", 25);
            this.methodText.setFont(this.font);
            this.methodText.setEditable(false);
            JLabel dateLabel = new JLabel("Date");
            dateLabel.setFont(this.font);
            this.dateText = new JTextField("", 25);
            this.dateText.setFont(this.font);
            this.dateText.setEditable(false);
            JLabel locationLabel = new JLabel("Location");
            locationLabel.setFont(this.font);
            this.locationText = new JTextField("", 25);
            this.locationText.setFont(this.font);
            this.locationText.setEditable(false);
            JLabel countryLabel = new JLabel("Country");
            countryLabel.setFont(this.font);
            this.countryText = new JTextField("", 25);
            this.countryText.setFont(this.font);
            this.countryText.setEditable(false);
            JLabel referenceLabel = new JLabel("Reference");
            referenceLabel.setFont(this.font);
            this.referenceText = new JTextField("", 25);
            this.referenceText.setFont(this.font);
            this.referenceText.setEditable(false);
            this.parent1Label = new JLabel("Group");
            this.parent1Label.setFont(this.font);
            this.parent1Text = new JTextField("", 25);
            this.parent1Text.setFont(this.font);
            this.parent1Text.setEditable(false);
            this.parent2Label = new JLabel("Source");
            this.parent2Label.setFont(this.font);
            this.parent2Text = new JTextField("", 25);
            this.parent2Text.setFont(this.font);
            this.parent2Text.setEditable(false);
            ArrayList<JPanel> subPanels = new ArrayList<JPanel>();
            int i = 0;
            while (i < 9) {
                JPanel subPanel = new JPanel();
                subPanel.setLayout(new FlowLayout(0));
                subPanels.add(subPanel);
                ++i;
            }
            ((JPanel)subPanels.get(0)).add(germplasmIdLabel);
            ((JPanel)subPanels.get(0)).add(this.germplasmIdText);
            ((JPanel)subPanels.get(1)).add(germplasmNameLabel);
            ((JPanel)subPanels.get(1)).add(this.germplasmNameText);
            ((JPanel)subPanels.get(2)).add(methodLabel);
            ((JPanel)subPanels.get(2)).add(this.methodText);
            ((JPanel)subPanels.get(3)).add(dateLabel);
            ((JPanel)subPanels.get(3)).add(this.dateText);
            ((JPanel)subPanels.get(4)).add(locationLabel);
            ((JPanel)subPanels.get(4)).add(this.locationText);
            ((JPanel)subPanels.get(5)).add(countryLabel);
            ((JPanel)subPanels.get(5)).add(this.countryText);
            ((JPanel)subPanels.get(6)).add(referenceLabel);
            ((JPanel)subPanels.get(6)).add(this.referenceText);
            ((JPanel)subPanels.get(7)).add(this.parent1Label);
            ((JPanel)subPanels.get(7)).add(this.parent1Text);
            ((JPanel)subPanels.get(8)).add(this.parent2Label);
            ((JPanel)subPanels.get(8)).add(this.parent2Text);
            i = 0;
            while (i < subPanels.size()) {
                panelGermplasmItemInfo.add((JPanel)subPanels.get(i));
                ++i;
            }
            PedigreeTreeComponent.addComp(this, panelGermplasmItemInfo, 1, 0, 1, 1, 1, 18, 1.0, 1.0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Unable to execute initGmsSearchDisplay.", ex);
        }
    }

    static void addComp(JComponent parent, JComponent component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, double weightx, double weighty) {
        GridBagConstraints gbc = PedigreeTreeComponent.createConstraints(gridx, gridy, gridwidth, gridheight, fill, anchor);
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        parent.add((Component)component, gbc);
    }

    static GridBagConstraints createConstraints(int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        return gbc;
    }

    public void valueChanged(TreeSelectionEvent evt) {
        PedigreeTreeNodeObject treeNode;
        DefaultMutableTreeNode node;
        if (evt.getSource() == this.pedigreeTree && (node = (DefaultMutableTreeNode)this.pedigreeTree.getLastSelectedPathComponent()) != null && (treeNode = (PedigreeTreeNodeObject)node.getUserObject()) != null && treeNode.getName() != null) {
            this.updateGermplasmItemInfo(treeNode);
        }
    }

    public void updatePedigreeTree(DefaultMutableTreeNode parentNode, long gid, String xmlString) throws Exception {
        XmlJTreeParser parser = new XmlJTreeParser();
        XmlJTreeHandler handler = new XmlJTreeHandler();
        handler.setVisibleNodeName("icis:germplasm");
        handler.setAttributeForNodeName("icis:nval");
        if (parentNode == null) {
            this.pedigreeTree.removeAll();
            this.pedigreeTree.setModel(parser.parse(xmlString, handler));
            this.pedigreeTree.setSelectionRow(0);
        } else {
            JTree treeTemp = new JTree();
            treeTemp.setModel(parser.parse(xmlString, handler));
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeTemp.getModel().getRoot();
            DefaultTreeModel treeModel = (DefaultTreeModel)this.pedigreeTree.getModel();
            Enumeration<TreeNode> children = rootNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            }
        }
    }

    public void updateGermplasmItemInfo(PedigreeTreeNodeObject treeNode) {
        try {
            this.germplasmIdText.setText(treeNode.getPropertyValue("icis:gid"));
            this.germplasmIdText.setCaretPosition(0);
            this.germplasmNameText.setText(treeNode.getPropertyValue("icis:nval"));
            this.germplasmNameText.setCaretPosition(0);
            this.methodText.setText(treeNode.getPropertyValue("icis:methn"));
            this.methodText.setCaretPosition(0);
            this.dateText.setText(treeNode.getPropertyValue("icis:date"));
            this.dateText.setCaretPosition(0);
            this.locationText.setText(treeNode.getPropertyValue("icis:lname"));
            this.locationText.setCaretPosition(0);
            this.countryText.setText(treeNode.getPropertyValue("icis:cntry"));
            this.countryText.setCaretPosition(0);
            this.referenceText.setText(treeNode.getPropertyValue("icis:ref"));
            this.referenceText.setCaretPosition(0);
            this.parent1Text.setText(treeNode.getPropertyValue("icis:parent1"));
            this.parent1Text.setCaretPosition(0);
            this.parent2Text.setText(treeNode.getPropertyValue("icis:parent2"));
            this.parent2Text.setCaretPosition(0);
            long gnpgs = Long.parseLong(treeNode.getPropertyValue("icis:gnpgs"));
            if (gnpgs > 0L) {
                this.parent1Label.setText("Female");
                this.parent2Label.setText("Male");
            } else {
                this.parent1Label.setText("Group");
                this.parent2Label.setText("Source");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clearComponents() {
        this.pedigreeTree.setModel(null);
        this.germplasmIdText.setText("");
        this.germplasmNameText.setText("");
        this.methodText.setText("");
        this.dateText.setText("");
        this.locationText.setText("");
        this.countryText.setText("");
        this.referenceText.setText("");
        this.parent1Text.setText("");
        this.parent2Text.setText("");
    }
}

