/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.io.File;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class InternetExplorerEngine
implements IBrowserEngine {
    private static final String NSPR4_DLL = "nspr4.dll";
    private static final String IELIB = "ielib";
    private static final String IEXPLORE = "iexplore";
    private static final String BROWSER_NAME = BrowserEngineManager.IE;
    private static String browserBinary = "IeEmbed.exe";
    private static boolean isEngineAvailable = true;
    private static boolean initialized = false;
    private static final String libPathEnv = WebBrowserUtil.LIB_PATH_ENV;
    private String browserFullPath = "";

    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public boolean isEngineAvailable() {
        isEngineAvailable = WebBrowserUtil.IS_OS_WINDOWS;
        return isEngineAvailable;
    }

    public boolean isDefaultBrowser(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().indexOf(IEXPLORE.toLowerCase()) >= 0;
    }

    protected boolean prepareVariables() {
        return true;
    }

    protected void setEnv() {
        String string = JdicManager.getManager().getBinaryPath() + File.separator + IELIB;
        File file = new File(string + NSPR4_DLL);
        if (file != null && file.exists()) {
            WebBrowserUtil.trace("nspr4.dll is set under " + string);
            InitUtility.preAppendEnv(libPathEnv, string);
        } else {
            WebBrowserUtil.error("nspr4.dll doesn't exist under " + string);
        }
    }

    public String getBrowserBinary() {
        return browserBinary;
    }

    public void initialize() throws JdicInitException {
        if (!initialized) {
            this.prepareVariables();
            this.setEnv();
            initialized = true;
            WebBrowserUtil.trace("IE Engine intialized");
        }
    }

    public String getEmbeddedBinaryName() {
        return browserBinary;
    }

    public void setEnginePath(String string) {
        this.browserFullPath = string;
    }

    public String getCharsetName() {
        return System.getProperty("file.encoding");
    }

    public String getFileProtocolURLPrefix() {
        return "file:/";
    }

    public boolean isInitialized() {
        return initialized;
    }

    public IWebBrowser getWebBrowser() {
        return new WebBrowser();
    }
}

