/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.types.BindXmlAutoNamingType;
import org.exolab.castor.mapping.xml.types.CollectionType;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.handlers.ContainerFieldHandler;
import org.exolab.castor.xml.handlers.EnumFieldHandler;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.exolab.castor.xml.validators.NameValidator;

public class XMLMappingLoader
extends MappingLoader {
    private static final Class[] EMPTY_ARGS = new Class[0];
    private static final String NCNAME = "NCName";
    private static final Class[] STRING_ARG = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLMappingLoader.class$("java.lang.String")) : class$java$lang$String};
    private static final String VALUE_OF = "valueOf";
    private XMLNaming _naming = null;
    private NodeType _primitiveNodeType = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$ContainerElement;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;

    public XMLMappingLoader(ClassLoader loader, PrintWriter logWriter) throws MappingException {
        super(loader, logWriter);
        LocalConfiguration config = LocalConfiguration.getInstance();
        this._primitiveNodeType = config.getPrimitiveNodeType();
        this._naming = config.getXMLNaming();
    }

    protected void resolveRelations(ClassDescriptor clsDesc) throws MappingException {
        FieldDescriptor[] fields = clsDesc.getFields();
        int i = 0;
        while (i < fields.length) {
            ClassDescriptor relDesc = this.getDescriptor(fields[i].getFieldType());
            if (relDesc != MappingLoader.NoDescriptor && relDesc != null && relDesc instanceof XMLClassDescriptor && fields[i] instanceof XMLFieldDescriptorImpl) {
                ((XMLFieldDescriptorImpl)fields[i]).setClassDescriptor((XMLClassDescriptor)relDesc);
            }
            ++i;
        }
        if (clsDesc instanceof XMLClassDescriptorImpl) {
            ((XMLClassDescriptorImpl)clsDesc).sortDescriptors();
        }
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        String xmlName;
        ClassDescriptor clsDesc = this.loadClassDescriptor(clsMap.getName());
        if (clsDesc != null && clsDesc instanceof XMLClassDescriptor) {
            return clsDesc;
        }
        clsDesc = super.createDescriptor(clsMap);
        MapTo mapTo = clsMap.getMapTo();
        if (mapTo == null || mapTo.getXml() == null) {
            String clsName = clsDesc.getJavaClass().getName();
            int idx = clsName.lastIndexOf(46);
            if (idx >= 0) {
                clsName = clsName.substring(idx + 1);
            }
            xmlName = this._naming.toXMLName(clsName);
        } else {
            xmlName = clsMap.getMapTo().getXml();
        }
        XMLClassDescriptorAdapter xmlClassDesc = new XMLClassDescriptorAdapter(clsDesc, xmlName, this._primitiveNodeType);
        if (clsMap.getAutoComplete()) {
            XMLClassDescriptor referenceDesc = null;
            Class type = xmlClassDesc.getJavaClass();
            ClassDescriptorResolverImpl cdr = new ClassDescriptorResolverImpl();
            cdr.setIntrospection(false);
            referenceDesc = cdr.resolve(type);
            if (referenceDesc == null) {
                Introspector introspector = new Introspector();
                try {
                    referenceDesc = introspector.generateClassDescriptor(type);
                }
                catch (MarshalException mx) {
                    String error = "unable to introspect class '" + type.getName() + "' for auto-complete: ";
                    throw new MappingException(error + mx.getMessage());
                }
            }
            String identity = "";
            if (clsMap.getIdentityCount() > 0) {
                identity = clsMap.getIdentity(0);
            }
            FieldDescriptor[] fields = xmlClassDesc.getFields();
            XMLFieldDescriptor[] introFields = referenceDesc.getAttributeDescriptors();
            int i = 0;
            while (i < introFields.length) {
                if (!this.isMatchFieldName(fields, introFields[i].getFieldName())) {
                    if (introFields[i].getFieldName().equals(identity)) {
                        xmlClassDesc.setIdentity(introFields[i]);
                    } else {
                        xmlClassDesc.addFieldDescriptor(introFields[i]);
                    }
                }
                ++i;
            }
            introFields = referenceDesc.getElementDescriptors();
            int i2 = 0;
            while (i2 < introFields.length) {
                if (!this.isMatchFieldName(fields, introFields[i2].getFieldName())) {
                    if (introFields[i2].getFieldName().equals(identity)) {
                        xmlClassDesc.setIdentity(introFields[i2]);
                    } else {
                        xmlClassDesc.addFieldDescriptor(introFields[i2]);
                    }
                }
                ++i2;
            }
            XMLFieldDescriptor field = referenceDesc.getContentDescriptor();
            if (field != null && this.isMatchFieldName(fields, field.getFieldName())) {
                xmlClassDesc.addFieldDescriptor(field);
            }
        }
        if (mapTo != null) {
            xmlClassDesc.setNameSpacePrefix(mapTo.getNsPrefix());
            xmlClassDesc.setNameSpaceURI(mapTo.getNsUri());
        }
        return xmlClassDesc;
    }

    private boolean isMatchFieldName(FieldDescriptor[] fields, String fieldName) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getFieldName().equals(fieldName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        Class fieldType;
        CollectionType colType;
        String xmlName = null;
        NodeType nodeType = null;
        String match = null;
        boolean isReference = false;
        boolean isXMLTransient = false;
        FieldDescriptor fieldDesc = super.createFieldDesc(javaClass, fieldMap);
        BindXml xml = fieldMap.getBindXml();
        boolean deriveNameByClass = false;
        if (xml != null) {
            xmlName = xml.getName();
            if (xml.getNode() != null) {
                nodeType = NodeType.getNodeType(xml.getNode().toString());
            }
            match = xml.getMatches();
            isReference = xml.getReference();
            isXMLTransient = xml.getTransient();
            BindXmlAutoNamingType autoName = xml.getAutoNaming();
            if (autoName != null) {
                deriveNameByClass = autoName == BindXmlAutoNamingType.DERIVEBYCLASS;
            }
        }
        isXMLTransient = isXMLTransient || fieldDesc.isTransient();
        String namespace = null;
        if (xmlName != null && xmlName.length() > 0 && xmlName.charAt(0) == '{') {
            int idx = xmlName.indexOf(125);
            if (idx < 0) {
                throw new MappingException("Invalid QName: " + xmlName);
            }
            namespace = xmlName.substring(1, idx);
            xmlName = xmlName.substring(idx + 1);
        }
        if (nodeType == null) {
            nodeType = XMLMappingLoader.isPrimitive(javaClass) ? this._primitiveNodeType : NodeType.Element;
        }
        if (!deriveNameByClass && xmlName == null && match == null) {
            xmlName = this._naming.toXMLName(fieldDesc.getFieldName());
            match = xmlName + ' ' + fieldDesc.getFieldName();
        }
        XMLFieldDescriptorImpl xmlDesc = new XMLFieldDescriptorImpl(fieldDesc, xmlName, nodeType, this._primitiveNodeType);
        xmlDesc.setTransient(isXMLTransient);
        xmlDesc.setValidator(new FieldValidator());
        if (deriveNameByClass) {
            xmlDesc.setXMLName(null);
        }
        if (namespace != null) {
            xmlDesc.setNameSpaceURI(namespace);
        }
        if (match != null) {
            xmlDesc.setMatches(match);
            if (xmlName == null) {
                xmlDesc.setXMLName(null);
            }
        }
        xmlDesc.setReference(isReference);
        xmlDesc.setContainer(fieldMap.getContainer());
        if (xml != null) {
            if (xml.getLocation() != null) {
                xmlDesc.setLocationPath(xml.getLocation());
            }
            String xmlType = xml.getType();
            xmlDesc.setSchemaType(xmlType);
            xmlDesc.setQNamePrefix(xml.getQNamePrefix());
            NameValidator validator = null;
            if (NCNAME.equals(xmlType)) {
                validator = new NameValidator(0);
                xmlDesc.setValidator(new FieldValidator(validator));
            }
        }
        if ((colType = fieldMap.getCollection()) != null) {
            String methodName;
            if (!(colType != CollectionType.HASHTABLE && colType != CollectionType.MAP || (methodName = fieldMap.getSetMethod()) == null || methodName.startsWith("add"))) {
                xmlDesc.setMapped(true);
            }
            if (nodeType == NodeType.Namespace) {
                FieldHandler handler = xmlDesc.getHandler();
                if (handler instanceof FieldHandlerImpl) {
                    FieldHandlerImpl handlerImpl = (FieldHandlerImpl)handler;
                    handlerImpl.setConvertFrom(new IdentityConvertor());
                }
            } else if (nodeType == NodeType.Element && fieldMap.hasContainer() && !fieldMap.getContainer()) {
                xmlDesc = this.wrapCollection(xmlDesc);
            }
        } else if (!(isReference || isXMLTransient || XMLMappingLoader.isPrimitive(fieldType = xmlDesc.getFieldType()))) {
            Constructor cons = null;
            try {
                cons = fieldType.getConstructor(EMPTY_ARGS);
                if (!Modifier.isPublic(cons.getModifiers())) {
                    cons = null;
                }
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
            try {
                Method method;
                Class<?> returnType;
                if (cons == null && (returnType = (method = fieldType.getMethod(VALUE_OF, STRING_ARG)).getReturnType()) != null && fieldType.isAssignableFrom(returnType) && fieldMap.getHandler() == null) {
                    FieldHandler handler = xmlDesc.getHandler();
                    handler = new EnumFieldHandler(fieldType, handler);
                    xmlDesc.setHandler(handler);
                    xmlDesc.setImmutable(true);
                }
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
        }
        String setter = fieldMap.getSetMethod();
        if (setter != null && setter.startsWith("%")) {
            int index = 0;
            index = Integer.parseInt(setter = setter.substring(1));
            if (index < 1 || index > 9) {
                throw new MappingException("mapper.invalidParameterIndex", setter);
            }
            xmlDesc.setConstructorArgumentIndex(--index);
        }
        return xmlDesc;
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        return new TypeInfo(fieldType, null, null, null, fieldMap.getRequired(), null, colHandler, false);
    }

    private XMLFieldDescriptorImpl wrapCollection(XMLFieldDescriptorImpl fieldDesc) throws MappingException {
        Class type = class$org$exolab$castor$xml$util$ContainerElement == null ? (class$org$exolab$castor$xml$util$ContainerElement = XMLMappingLoader.class$("org.exolab.castor.xml.util.ContainerElement")) : class$org$exolab$castor$xml$util$ContainerElement;
        XMLClassDescriptorImpl classDesc = new XMLClassDescriptorImpl(type);
        XMLFieldDescriptorImpl newFieldDesc = new XMLFieldDescriptorImpl(fieldDesc, fieldDesc.getXMLName(), fieldDesc.getNodeType(), this._primitiveNodeType);
        newFieldDesc.setXMLName(null);
        classDesc.addFieldDescriptor(newFieldDesc);
        fieldDesc.setClassDescriptor(classDesc);
        ContainerFieldHandler handler = new ContainerFieldHandler(fieldDesc.getHandler());
        newFieldDesc.setHandler(handler);
        fieldDesc.setHandler(handler);
        return new ContainerElementFieldDescriptor(fieldDesc, this._primitiveNodeType);
    }

    private static boolean isPrimitive(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLMappingLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Character == null ? (class$java$lang$Character = XMLMappingLoader.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = XMLMappingLoader.class$("java.lang.Number")) : class$java$lang$Number);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ContainerElementFieldDescriptor
    extends XMLFieldDescriptorImpl {
        static /* synthetic */ Class class$org$exolab$castor$xml$util$ContainerElement;

        ContainerElementFieldDescriptor(XMLFieldDescriptorImpl fieldDesc, NodeType primitiveNodeType) throws MappingException {
            super(fieldDesc, fieldDesc.getXMLName(), fieldDesc.getNodeType(), primitiveNodeType);
        }

        public Class getFieldType() {
            return class$org$exolab$castor$xml$util$ContainerElement == null ? (class$org$exolab$castor$xml$util$ContainerElement = ContainerElementFieldDescriptor.class$("org.exolab.castor.xml.util.ContainerElement")) : class$org$exolab$castor$xml$util$ContainerElement;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class IdentityConvertor
    implements TypeConvertor {
        IdentityConvertor() {
        }

        public Object convert(Object object, String param) throws ClassCastException {
            return object;
        }
    }
}

