/*
 * Decompiled with CFR 0.152.
 */
package org.cgiar.icis.pedigree;

import java.util.Enumeration;
import java.util.Properties;
import org.xml.sax.Attributes;

public abstract class NodeObject {
    private String name = "";
    private Properties attributes = null;
    private String data = "";

    public NodeObject(String name, Attributes attributes) {
        this.name = name;
        this.attributes = this.getAttributesAsProperties(attributes);
    }

    public String getName() {
        return this.name;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public void addData(String data) {
        if (this.data == null) {
            this.setData(data);
        } else {
            this.data = String.valueOf(this.data) + data;
        }
    }

    public String getPropertyValue(String propertyName) {
        return this.attributes.getProperty(propertyName);
    }

    private Properties getAttributesAsProperties(Attributes attributes) {
        Properties properties = new Properties();
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            properties.setProperty(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        return properties;
    }

    public String getAttributesAsString() {
        StringBuffer sbuf = new StringBuffer();
        Enumeration<?> names = this.attributes.propertyNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            sbuf.append(String.valueOf(key) + "=" + this.attributes.getProperty(key));
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.name;
    }
}

