/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.soap;

import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.wsdl.LSIDStandardPort;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPUtils
implements SOAPConstants,
HTTPConstants {
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static SimpleDateFormat DATE_TIME_FORMAT_131 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static SimpleDateFormat DATE_TIME_FORMAT_AXIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static LSIDException processAxisFault(AxisFault fault) {
        Node node;
        int i;
        NodeList list;
        Element returnCodeElt = fault.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
        int returnCode = -1;
        if (returnCodeElt != null) {
            NodeList list2 = returnCodeElt.getChildNodes();
            for (int i2 = 0; i2 < list2.getLength(); ++i2) {
                Node node2 = list2.item(i2);
                if (node2.getNodeType() != 3) continue;
                returnCode = Integer.parseInt(node2.getNodeValue());
            }
        }
        if (returnCode == 401) {
            Element stringElt = fault.lookupFaultDetail(new QName(null, "string"));
            NodeList list3 = stringElt.getChildNodes();
            String string = null;
            for (int i3 = 0; i3 < list3.getLength(); ++i3) {
                Node node3 = list3.item(i3);
                if (node3.getNodeType() != 3) continue;
                string = node3.getNodeValue();
            }
            return new LSIDException(700, string);
        }
        Element errorCodeElt = fault.lookupFaultDetail(new QName("errorcode"));
        Element descriptionElt = fault.lookupFaultDetail(new QName("description"));
        Element stacktraceElt = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME);
        int errorCode = -1;
        String description = null;
        String stacktrace = null;
        if (errorCodeElt != null) {
            list = errorCodeElt.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (node.getNodeType() != 3) continue;
                errorCode = Integer.parseInt(node.getNodeValue());
            }
        }
        if (descriptionElt != null) {
            list = descriptionElt.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (node.getNodeType() != 3) continue;
                description = node.getNodeValue();
            }
        }
        if (stacktraceElt != null) {
            list = stacktraceElt.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (node.getNodeType() != 3) continue;
                stacktrace = node.getNodeValue();
            }
        }
        if (errorCode == -1) {
            errorCode = 500;
        }
        String desc = "";
        if (description != null) {
            desc = desc + description;
        }
        return new LSIDException((Exception)((Object)fault), errorCode, desc);
    }

    public static Call createCall(LSIDStandardPort port, LSIDCredentials credentials, String enc) throws LSIDException {
        try {
            return SOAPUtils.createCall(new URL(port.getLocation()), port.getProtocolHeaders(), credentials, enc);
        }
        catch (MalformedURLException e) {
            throw new LSIDException(711, "Malformed endpoint");
        }
    }

    public static Call createCall(LSIDStandardPort port, LSIDCredentials credentials) throws LSIDException {
        try {
            return SOAPUtils.createCall(new URL(port.getLocation()), port.getProtocolHeaders(), credentials, null);
        }
        catch (MalformedURLException e) {
            throw new LSIDException(711, "Malformed endpoint");
        }
    }

    public static Call createCall(URL endpoint, Map headers, LSIDCredentials credentials, String enc) throws LSIDException {
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setEncodingStyle(enc);
            call.setReturnType(XMLType.AXIS_VOID);
            call.setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.mime");
            call.setProperty("send_type_attr", (Object)Boolean.FALSE);
            call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            if (credentials != null) {
                call.setUsername((String)credentials.getProperty("basicUsername"));
                call.setPassword((String)credentials.getProperty("basicPassword"));
            }
            call.setTargetEndpointAddress(endpoint);
            Object[] keys = headers.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String headerName = (String)keys[i];
                String headerValue = (String)headers.get(headerName);
                SOAPHeaderElement elt = new SOAPHeaderElement(null, headerName, (Object)headerValue);
                call.addHeader(elt);
            }
            return call;
        }
        catch (Exception e) {
            throw new LSIDException(e, "Error creating call object");
        }
    }

    public static String writeDate(Date date) {
        try {
            return DATE_TIME_FORMAT_AXIS.format(date);
        }
        catch (IllegalArgumentException e) {
            return DATE_TIME_FORMAT_131.format(date);
        }
    }

    public static Date parseDate(String date) throws LSIDException {
        try {
            try {
                return DATE_TIME_FORMAT_AXIS.parse(date);
            }
            catch (Exception e) {
                return DATE_TIME_FORMAT_131.parse(date);
            }
        }
        catch (ParseException e) {
            throw new LSIDException(e, "Error parsing date: " + date);
        }
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_TIME_FORMAT_131.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

