/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.conf.LSIDResolverConfig;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.ftp.FTPUtils;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.http.HTTPResponse;
import com.ibm.lsid.http.HTTPUtils;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.soap.SOAPUtils;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.types.URI;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.dns;

public class LSIDResolver
implements WSDLConstants,
SOAPConstants,
HTTPConstants {
    public static final String ANY_AUTHORITY = "*";
    private LSIDAuthority authority;
    private LSID lsid;
    private LSIDWSDLWrapper wsdlWrapper;
    private LSIDCache cache;
    private boolean useCache;
    private LSIDCredentials runtimeCredentials;
    private LSIDCredentials lsidCredentials;
    private static LSIDResolverConfig config = new LSIDResolverConfig();
    private static final int NOTIFY = 0;
    private static final int REVOKE = 1;
    static /* synthetic */ Class class$org$apache$axis$types$URI;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public static void setResolverHome(String location) {
        String home = System.getProperty("LSID_CLIENT_HOME");
        if (home == null) {
            System.setProperty("LSID_CLIENT_HOME", location);
            config = new LSIDResolverConfig();
        }
    }

    public static LSIDResolverConfig getConfig() {
        return config;
    }

    public static LSIDAuthority resolveAuthority(LSIDAuthority authority) throws LSIDException {
        if (authority.isResolved()) {
            return authority;
        }
        String url = (String)config.getHostMappings().get(authority.getAuthority());
        if (url == null) {
            url = (String)config.getHostMappings().get(ANY_AUTHORITY);
        }
        if (url != null) {
            authority.setUrl(url);
        } else {
            Record[] records = dns.getRecords((String)("_lsid._tcp." + authority), (short)33);
            if (records != null && records.length > 0 && records[0] != null && records[0] instanceof SRVRecord) {
                SRVRecord rec = (SRVRecord)records[0];
                authority.setPort(rec.getPort());
                String server = rec.getTarget().toString();
                if (server.charAt(server.length() - 1) == '.') {
                    server = server.substring(0, server.length() - 1);
                }
                authority.setServer(server);
            } else {
                authority.setPort(80);
                authority.setServer(authority.getAuthority());
            }
        }
        try {
            LSIDWSDLWrapper wrapper = null;
            if (config.useCache()) {
                wrapper = config.getCache().readWSDL(authority, null);
            }
            if (wrapper == null) {
                HTTPResponse resp = HTTPUtils.doGet(authority.getUrl(), null, null, null);
                wrapper = new LSIDWSDLWrapper(resp.getData());
                wrapper.setExpiration(resp.getExpiration());
                if (config.useCache()) {
                    config.getCache().writeWSDL(authority, null, wrapper);
                }
            }
            authority.setWSDL(wrapper);
        }
        catch (LSIDException e) {
            System.err.println("Error getting WSDL for authority: " + url + ", will attempt default bindings");
        }
        return authority;
    }

    public static void notifyForeignAuthority(LSIDAuthority foreignAuthority, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        LSIDResolver.notifyForeignAuthority(0, foreignAuthority, lsid, credentials);
    }

    public static void revokeNotificationForeignAuthority(LSIDAuthority foreignAuthority, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        LSIDResolver.notifyForeignAuthority(1, foreignAuthority, lsid, credentials);
    }

    private static void notifyForeignAuthority(int op, LSIDAuthority foreignAuthority, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        LSIDAuthority authority = lsid.getAuthority();
        if (!authority.isResolved()) {
            LSIDResolver.resolveAuthority(authority);
        }
        LSIDWSDLWrapper wrapper = authority.getWSDL();
        LSIDAuthorityPort authorityPort = wrapper.getAuthorityPortForProtocol("soap");
        String protocol = authorityPort.getProtocol();
        Object data = null;
        if (credentials == null) {
            credentials = authorityPort.getLsidCredentials();
        }
        if (protocol.equals("soap")) {
            try {
                String opName = "notifyForeignAuthority";
                if (op == 1) {
                    opName = "revokeNotificationForeignAuthority";
                }
                Call call = SOAPUtils.createCall(authorityPort, credentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", opName));
                Vector<Object> params = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                params.add(new URI(lsid.toString()));
                call.addParameter("authorityName", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.IN);
                params.add(foreignAuthority.toString());
                call.invoke(params.toArray());
                Message rspmsg = call.getResponseMessage();
            }
            catch (AxisFault e) {
                throw SOAPUtils.processAxisFault(e);
            }
            catch (RemoteException e) {
                throw new LSIDException(e, "Remote exception processing request");
            }
            catch (IOException e) {
                throw new LSIDException(e, "IO Error notifying authority");
            }
        } else if (protocol.equals("http")) {
            String authloc = authorityPort.getLocation();
            if (authloc.endsWith("/")) {
                authloc = authloc.substring(0, authloc.length() - 1);
            }
            authloc = op == 0 ? authloc + "/authority/notify/" : authloc + "/authority/revoke/";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("lsid", lsid);
            params.put("authorityName", foreignAuthority.toString());
            HTTPResponse resp = HTTPUtils.doGet(authloc, authorityPort.getProtocolHeaders(), params, credentials);
        } else {
            throw new LSIDException("Cannot notify authority over protocol: " + protocol);
        }
    }

    public static LSIDCache getCache() {
        return config.getCache();
    }

    public LSIDResolver(LSID lsid) throws LSIDException {
        this.lsid = lsid;
        this.authority = lsid.getAuthority();
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.lsidCredentials = new LSIDCredentials(lsid);
    }

    public LSIDResolver(LSIDAuthority authority, LSID lsid) throws LSIDException {
        this.authority = authority;
        this.lsid = lsid;
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.lsidCredentials = new LSIDCredentials(lsid);
    }

    public LSIDResolver(LSID lsid, LSIDCredentials credentials) throws LSIDException {
        this.lsid = lsid;
        this.authority = lsid.getAuthority();
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.runtimeCredentials = credentials;
        this.lsidCredentials = new LSIDCredentials(lsid);
    }

    public LSIDResolver(LSIDAuthority authority, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        this.authority = authority;
        this.lsid = lsid;
        this.cache = config.getCache();
        this.useCache = config.useCache();
        this.runtimeCredentials = credentials;
        this.lsidCredentials = new LSIDCredentials(lsid);
    }

    public void setUseLocalCache(boolean use) {
        this.useCache = config.useCache() && use;
    }

    public LSID getLSID() throws LSIDException {
        return this.lsid;
    }

    public LSIDAuthority getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LSIDWSDLWrapper getWSDLWrapper() throws LSIDException {
        if (this.wsdlWrapper != null) {
            return this.wsdlWrapper;
        }
        LSIDResolver lSIDResolver = this;
        synchronized (lSIDResolver) {
            if (this.wsdlWrapper == null) {
                this.fetchWSDL();
            }
            return this.wsdlWrapper;
        }
    }

    public InputStream getData() throws LSIDException {
        this.getWSDLWrapper();
        LSIDDataPort port = this.wsdlWrapper.getDataPort();
        return this.getData(port, -1, -1);
    }

    public InputStream getData(int start, int length) throws LSIDException {
        this.getWSDLWrapper();
        LSIDDataPort port = this.wsdlWrapper.getDataPort();
        return this.getData(port, start, length);
    }

    public InputStream getData(LSIDDataPort port) throws LSIDException {
        if (port == null) {
            throw new LSIDException("Null data port provided");
        }
        return this.getData(port, -1, -1);
    }

    public InputStream getData(LSIDDataPort port, int start, int length) throws LSIDException {
        if (port == null) {
            throw new LSIDException("Null data port provided");
        }
        InputStream in = null;
        if (this.useCache) {
            in = this.cache.readData(this.lsid, start, length);
        }
        if (in == null) {
            this.getWSDLWrapper();
            in = this.getDataFromPort(port, start, length);
            if (this.useCache) {
                return this.cache.writeData(this.lsid, in, start, length);
            }
        }
        return in;
    }

    public LSIDMetadata getMetadataStore() throws LSIDException {
        MetadataResponse metadata = this.getMetadata();
        String format = metadata.getFormat();
        if (format == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata store = config.getMetadataFactory(format).createInstance();
        store.addMetadata(metadata);
        return store;
    }

    public LSIDMetadata getMetadataStore(String[] acceptedFormats) throws LSIDException {
        MetadataResponse metadata = this.getMetadata(acceptedFormats);
        String format = metadata.getFormat();
        if (format == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata store = config.getMetadataFactory(format).createInstance();
        store.addMetadata(metadata);
        return store;
    }

    public LSIDMetadata getMetadataStore(LSIDMetadataPort port) throws LSIDException {
        MetadataResponse metadata = this.getMetadata(port);
        String format = metadata.getFormat();
        if (format == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata store = config.getMetadataFactory(format).createInstance();
        store.addMetadata(metadata);
        return store;
    }

    public LSIDMetadata getMetadataStore(LSIDMetadataPort port, String[] acceptedFormats) throws LSIDException {
        MetadataResponse metadata = this.getMetadata(port, acceptedFormats);
        String format = metadata.getFormat();
        if (format == null) {
            throw new LSIDException("Can't create store, no metadata format received");
        }
        LSIDMetadata store = config.getMetadataFactory(format).createInstance();
        store.addMetadata(metadata);
        return store;
    }

    public MetadataResponse getMetadata() throws LSIDException {
        this.getWSDLWrapper();
        LSIDMetadataPort port = this.wsdlWrapper.getMetadataPort();
        if (port == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(port, new String[0]);
    }

    public MetadataResponse getMetadata(String[] acceptedFormats) throws LSIDException {
        this.getWSDLWrapper();
        LSIDMetadataPort port = this.wsdlWrapper.getMetadataPort();
        if (port == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(port, acceptedFormats);
    }

    public MetadataResponse getMetadata(LSIDMetadataPort port) throws LSIDException {
        if (port == null) {
            throw new LSIDException(400, "No meta data available for lsid: " + this.lsid);
        }
        return this.getMetadata(port, new String[0]);
    }

    public MetadataResponse getMetadata(LSIDMetadataPort port, String[] acceptedFormats) throws LSIDException {
        if (port == null) {
            throw new LSIDException("Null meta data port specified");
        }
        MetadataResponse response = null;
        if (acceptedFormats != null && acceptedFormats.length < 1) {
            acceptedFormats = config.getAcceptedFormats();
        }
        if (this.useCache) {
            response = this.cache.readMetadata(this.authority, this.lsid, port.getServiceName(), port.getName(), acceptedFormats);
        }
        if (response == null) {
            this.getWSDLWrapper();
            String formatsStr = null;
            if (acceptedFormats != null) {
                formatsStr = acceptedFormats[0];
                for (int i = 1; i < acceptedFormats.length; ++i) {
                    formatsStr = formatsStr + "," + acceptedFormats[i];
                }
            }
            response = this.getMetadataFromPort(port, formatsStr);
            if (this.useCache) {
                InputStream cachingStream = this.cache.writeMetadata(this.authority, this.lsid, port.getServiceName(), port.getName(), (InputStream)response.getValue(), response.getExpires(), response.getFormat());
                response.setValue(cachingStream);
            }
        }
        return response;
    }

    private InputStream getDataFromPort(LSIDDataPort ldp, int start, int length) throws LSIDException {
        if (ldp == null) {
            throw new LSIDException(300, "No data available for LSID  " + this.lsid);
        }
        String protocol = ldp.getProtocol();
        String location = ldp.getLocation();
        String path = ldp.getPath();
        LSIDCredentials credentials = null;
        credentials = this.runtimeCredentials;
        Object data = null;
        if (credentials == null) {
            credentials = ldp.getLsidCredentials();
        }
        if (credentials == null) {
            credentials = this.lsidCredentials;
        }
        if (protocol == null || location == null) {
            throw new LSIDException(300, "No Data Available for LSID: " + this.lsid);
        }
        if (protocol.equals("http")) {
            HashMap<String, Object> params = null;
            if (ldp.getPath().equals("urlEncoded")) {
                params = new HashMap<String, Object>();
                if (start != -1 && length != -1) {
                    params.put("start", String.valueOf(start));
                    params.put("length", String.valueOf(length));
                }
                params.put("lsid", this.lsid);
            }
            HTTPResponse resp = HTTPUtils.doGet(location, ldp.getProtocolHeaders(), params, credentials);
            return resp.getData();
        }
        if (protocol.equals("ftp")) {
            if (start != -1 && length != -1) {
                throw new LSIDException(501, "getDataByRange not supported over FTP protocol, use InputStream API for chunking.");
            }
            return FTPUtils.doGet(location, path, credentials);
        }
        if (protocol.equals("file")) {
            if (start != -1 && length != -1) {
                throw new LSIDException(501, "getDataByRange not supported over File protocol, use InputStream API for chunking.");
            }
            try {
                return new FileInputStream(location);
            }
            catch (FileNotFoundException e) {
                throw new LSIDException(e, 300, "Could not open data file " + location);
            }
        }
        if (protocol.equals("soap")) {
            try {
                Call call = SOAPUtils.createCall(ldp, credentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "getData"));
                Vector<Object> params = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                params.add(new URI(this.lsid.toString()));
                if (start != -1 && length != -1) {
                    call.addParameter("start", Constants.XSD_INTEGER, class$java$lang$Integer == null ? (class$java$lang$Integer = LSIDResolver.class$("java.lang.Integer")) : class$java$lang$Integer, ParameterMode.IN);
                    params.add(new Integer(start));
                    call.addParameter("length", Constants.XSD_INTEGER, class$java$lang$Integer == null ? (class$java$lang$Integer = LSIDResolver.class$("java.lang.Integer")) : class$java$lang$Integer, ParameterMode.IN);
                    params.add(new Integer(length));
                }
                call.invoke(params.toArray());
                Message rspmsg = call.getResponseMessage();
                Attachments reqAttach = rspmsg.getAttachmentsImpl();
                AttachmentPart attachment = (AttachmentPart)reqAttach.getAttachments().toArray()[0];
                DataHandler dh = attachment.getDataHandler();
                return dh.getInputStream();
            }
            catch (MalformedURLException e) {
                throw new LSIDException(e, "bad authority url: " + ldp.getLocation());
            }
            catch (AxisFault e) {
                throw SOAPUtils.processAxisFault(e);
            }
            catch (RemoteException e) {
                throw new LSIDException(e, "Remote exception processing request");
            }
            catch (SOAPException e) {
                throw new LSIDException((Exception)((Object)e), "Error processing response");
            }
            catch (IOException e) {
                throw new LSIDException(e, "Error getting input stream from attachment");
            }
        }
        throw new LSIDException(300, "No Data Available for LSID: " + this.lsid + " using port: " + ldp.getName());
    }

    private MetadataResponse getMetadataFromPort(LSIDMetadataPort lmdp, String formatsStr) throws LSIDException {
        if (lmdp == null) {
            throw new LSIDException(400, "No meta data available for LSID  " + this.lsid);
        }
        String protocol = lmdp.getProtocol();
        String location = lmdp.getLocation();
        String path = lmdp.getPath();
        if (protocol == null || location == null) {
            throw new LSIDException(400, "No Meta Data Available for LSID: " + this.lsid + " using port: " + lmdp.getName());
        }
        LSIDCredentials credentials = this.runtimeCredentials;
        if (credentials == null) {
            credentials = lmdp.getLsidCredentials();
        }
        if (credentials == null) {
            credentials = this.lsidCredentials;
        }
        if (protocol.equals("http")) {
            HashMap<String, String> params = null;
            if (lmdp.getPath().equals("urlEncoded")) {
                params = new HashMap<String, String>();
                params.put("lsid", this.lsid.toString());
                if (formatsStr != null) {
                    params.put("acceptedFormats", formatsStr);
                }
            }
            HTTPResponse resp = HTTPUtils.doGet(location, lmdp.getProtocolHeaders(), params, credentials);
            String contentType = resp.getContentType();
            int ind = contentType.indexOf(59);
            String format = null;
            format = ind != -1 ? contentType.substring(0, ind) : contentType;
            return new MetadataResponse((Object)resp.getData(), resp.getExpiration(), format);
        }
        if (protocol.equals("ftp")) {
            InputStream data = FTPUtils.doGet(location, path, credentials);
            return new MetadataResponse((Object)data, null, null);
        }
        if (protocol.equals("file")) {
            try {
                FileInputStream data = new FileInputStream(location);
                return new MetadataResponse((Object)data, null, null);
            }
            catch (FileNotFoundException e) {
                throw new LSIDException(e, 400, "Could not open metadata file " + location);
            }
        }
        if (protocol.equals("soap")) {
            try {
                Call call = SOAPUtils.createCall(lmdp, credentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "getMetadata"));
                Vector<Object> params = new Vector<Object>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                params.add(new URI(this.lsid.toString()));
                if (formatsStr != null) {
                    call.addParameter("acceptedFormats", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.IN);
                    params.add(formatsStr);
                }
                call.addParameter("format", Constants.XSD_STRING, class$java$lang$String == null ? (class$java$lang$String = LSIDResolver.class$("java.lang.String")) : class$java$lang$String, ParameterMode.OUT);
                call.addParameter("expiration", Constants.XSD_DATETIME, class$java$util$Date == null ? (class$java$util$Date = LSIDResolver.class$("java.util.Date")) : class$java$util$Date, ParameterMode.OUT);
                call.invoke(params.toArray());
                Message rspmsg = call.getResponseMessage();
                Map outparams = call.getOutputParams();
                String format = (String)outparams.get(new QName(null, "format"));
                Date expires = (Date)outparams.get(new QName(null, "expiration"));
                Attachments reqAttach = rspmsg.getAttachmentsImpl();
                AttachmentPart attachment = (AttachmentPart)reqAttach.getAttachments().toArray()[0];
                DataHandler dh = attachment.getDataHandler();
                return new MetadataResponse((Object)dh.getInputStream(), expires, format);
            }
            catch (MalformedURLException e) {
                throw new LSIDException(e, "bad authority url: " + lmdp.getLocation());
            }
            catch (AxisFault e) {
                throw SOAPUtils.processAxisFault(e);
            }
            catch (RemoteException e) {
                throw new LSIDException(e, "Remote exception processing request");
            }
            catch (SOAPException e) {
                throw new LSIDException((Exception)((Object)e), "Error processing response");
            }
            catch (IOException e) {
                throw new LSIDException(e, "Error getting input stream from attachment");
            }
        }
        return null;
    }

    private void resolveAuthority() throws LSIDException {
        this.authority = LSIDResolver.resolveAuthority(this.authority);
    }

    private void fetchWSDL() throws LSIDException {
        this.wsdlWrapper = null;
        Date expires = null;
        int i = -1;
        LSIDAuthority currentAuthority = this.authority;
        LSIDAuthority[] foreignAuthorities = config.getForeignAuthorities(this.lsid);
        do {
            LSIDWSDLWrapper newWrapper = null;
            if (this.useCache) {
                newWrapper = this.cache.readWSDL(currentAuthority, this.lsid);
            }
            if (newWrapper == null) {
                if (!currentAuthority.isResolved()) {
                    // empty if block
                }
                LSIDResolver.resolveAuthority(currentAuthority);
                try {
                    LSIDWSDLWrapper authorityWSDL = this.authority.getWSDL();
                    LSIDAuthorityPort authorityPort = null;
                    if (authorityWSDL != null) {
                        authorityPort = authorityWSDL.getAuthorityPortForProtocol("http");
                    }
                    if (authorityPort == null) {
                        authorityPort = new SOAPLocation(currentAuthority.getUrl());
                    }
                    newWrapper = this.fetchWSDL(authorityPort);
                    if (this.useCache) {
                        this.cache.writeWSDL(currentAuthority, this.lsid, newWrapper);
                    }
                }
                catch (LSIDException e) {
                    if (i > -1 && e.getErrorCode() == 201) {
                        if (foreignAuthorities != null && ++i < foreignAuthorities.length) {
                            currentAuthority = foreignAuthorities[i];
                            continue;
                        }
                        currentAuthority = null;
                        continue;
                    }
                    throw e;
                }
            }
            if (i == -1) {
                this.wsdlWrapper = newWrapper;
            } else {
                LSIDWSDLWrapper foreignWrapper = newWrapper;
                Enumeration e = foreignWrapper.getDataPortNames();
                while (e.hasMoreElements()) {
                    LSIDDataPort dataPort = foreignWrapper.getDataPort(e.nextElement().toString());
                    this.wsdlWrapper.setDataLocation(dataPort);
                }
                Enumeration em = foreignWrapper.getMetadataPortNames();
                while (em.hasMoreElements()) {
                    LSIDMetadataPort metadata = foreignWrapper.getMetadataPort(em.nextElement().toString());
                    this.wsdlWrapper.setMetadataLocation(metadata);
                }
            }
            ++i;
            currentAuthority = foreignAuthorities != null && i < foreignAuthorities.length ? foreignAuthorities[i] : null;
        } while (currentAuthority != null);
        this.wsdlWrapper.setExpiration(expires);
    }

    private LSIDWSDLWrapper fetchWSDL(LSIDAuthorityPort authorityPort) throws LSIDException {
        String protocol = authorityPort.getProtocol();
        LSIDCredentials credentials = this.runtimeCredentials;
        Object data = null;
        if (credentials == null) {
            credentials = authorityPort.getLsidCredentials();
        }
        if (credentials == null) {
            credentials = this.lsidCredentials;
        }
        if (protocol.equals("soap")) {
            try {
                Call call = SOAPUtils.createCall(authorityPort, credentials);
                call.setOperationName(new QName("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", "getAvailableServices"));
                Vector<URI> params = new Vector<URI>();
                call.addParameter("lsid", Constants.XSD_ANYURI, class$org$apache$axis$types$URI == null ? (class$org$apache$axis$types$URI = LSIDResolver.class$("org.apache.axis.types.URI")) : class$org$apache$axis$types$URI, ParameterMode.IN);
                params.add(new URI(this.lsid.toString()));
                call.invoke(params.toArray());
                Message rspmsg = call.getResponseMessage();
                Date exp = null;
                SOAPHeaderElement header = rspmsg.getSOAPEnvelope().getHeaderByName(null, "expires");
                if (header != null) {
                    String expStr = header.getValue();
                    exp = SOAPUtils.parseDate(expStr);
                }
                Attachments reqAttach = rspmsg.getAttachmentsImpl();
                AttachmentPart attachment = (AttachmentPart)reqAttach.getAttachments().toArray()[0];
                DataHandler dh = attachment.getDataHandler();
                LSIDWSDLWrapper wrapper = new LSIDWSDLWrapper(dh.getInputStream());
                wrapper.setExpiration(exp);
                return wrapper;
            }
            catch (MalformedURLException e) {
                throw new LSIDException(e, "bad authority url: " + authorityPort.getLocation());
            }
            catch (AxisFault e) {
                throw SOAPUtils.processAxisFault(e);
            }
            catch (RemoteException e) {
                throw new LSIDException(e, "Remote exception processing request");
            }
            catch (SOAPException e) {
                throw new LSIDException((Exception)((Object)e), "Error processing response");
            }
            catch (IOException e) {
                throw new LSIDException(e, "Error getting input stream from attachment");
            }
        }
        if (protocol.equals("http")) {
            String authloc = authorityPort.getLocation();
            if (authloc.endsWith("/")) {
                authloc = authloc.substring(0, authloc.length() - 1);
            }
            authloc = authloc + "/authority/";
            HashMap<String, LSID> params = new HashMap<String, LSID>();
            params.put("lsid", this.lsid);
            HTTPResponse resp = HTTPUtils.doGet(authloc, authorityPort.getProtocolHeaders(), params, credentials);
            LSIDWSDLWrapper wrapper = new LSIDWSDLWrapper(resp.getData());
            wrapper.setExpiration(resp.getExpiration());
            return wrapper;
        }
        throw new LSIDException("Cannot fetch wsdl over protocol: " + protocol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

