/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.awt.Component;
import java.awt.Container;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class DumpTagHandler
extends AbstractTagHandler {
    public DumpTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        Object object = this.getXMLTestCase().getProperty(this.getRefId());
        if (object == null) {
            throw new XMLException("Referenced object could not be found", null, this.getElement(), this.getTest().getPropertyCache());
        }
        if (!(object instanceof Component)) {
            throw new XMLException("Referenced object is not java.awt.Component", null, this.getElement(), this.getTest().getPropertyCache());
        }
        DumpTagHandler.dumpComponents((Component)object, 1, this.getRecursive());
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("dump");
        this.checkRequiredAttribute("refid");
    }

    private static void dumpComponents(Component parent, int level, boolean recursive) {
        String indent = "";
        for (int t = 0; t < level; ++t) {
            indent = indent + "   ";
        }
        String name = parent.getName();
        if (name == null) {
            name = "<anonymous>";
        }
        System.out.println(indent + name + "(" + parent + ")");
        if (parent instanceof Container) {
            Component[] children = ((Container)parent).getComponents();
            for (int t = 0; t < children.length; ++t) {
                if (recursive) {
                    DumpTagHandler.dumpComponents(children[t], level + 1, recursive);
                    continue;
                }
                name = children[t].getName();
                if (name == null) {
                    name = "<anonymous>";
                }
                System.out.println(indent + name + "(" + children[t] + ")");
            }
        }
    }

    private boolean getRecursive() {
        return this.getBoolean("recursive", true);
    }

    private String getRefId() {
        return this.getString("refid");
    }
}

