/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;
import junit.extensions.jfcunit.finder.Finder;

public class LabeledComponentFinder
extends Finder {
    private String m_text = null;
    private boolean m_caseIndependent = true;

    public LabeledComponentFinder(String text, boolean caseIndependent) {
        this.setText(text);
        this.m_caseIndependent = caseIndependent;
        super.createPatternMatcher(text, caseIndependent);
    }

    public void setCaseIndependent(boolean ignoreCase) {
        super.setCaseIndependent(ignoreCase);
        this.m_caseIndependent = ignoreCase;
        this.createPatternMatcher(this.m_text, this.m_caseIndependent);
    }

    public final void setText(String text) {
        this.m_text = text;
        this.createPatternMatcher(this.m_text, this.m_caseIndependent);
    }

    public final String getText() {
        return this.m_text;
    }

    public boolean testComponent(Component comp) {
        if (comp != null && comp instanceof JLabel) {
            JLabel lbl = (JLabel)comp;
            return super.evaluate(this.getText(), lbl.getText());
        }
        return false;
    }

    public Component find(Container[] conts, int index) {
        Component c = super.find(conts, index);
        if (c != null) {
            c = ((JLabel)c).getLabelFor();
        }
        return c;
    }
}

