/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class JTableHeaderMouseEventData
extends AbstractMouseEventData {
    private JTableHeader m_header;
    private int m_columnIndex;

    public JTableHeaderMouseEventData() {
        this.setValid(false);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks) {
        this(testCase, header, columnIndex, numberOfClicks, 300L);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, long sleepTime) {
        this(testCase, header, columnIndex, numberOfClicks, false, sleepTime);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, header, columnIndex, numberOfClicks, isPopupTrigger, 300L);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, header, columnIndex, numberOfClicks, JTableHeaderMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, header, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, header, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, header, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JTableHeaderMouseEventData(JFCTestCase testCase, JTableHeader header, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(header);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setColumnIndex(columnIndex);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setColumnIndex(int columnIndex) {
        this.m_columnIndex = columnIndex;
    }

    public final int getColumnIndex() {
        return this.m_columnIndex;
    }

    public final void setSource(JTableHeader header) {
        this.m_header = header;
    }

    public final JTableHeader getSource() {
        return this.m_header;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public boolean canConsume(AWTEvent ae) {
        return ae.getSource() instanceof JTableHeader && super.canConsume(ae) && this.sameSource(ae);
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JTableHeader source = (JTableHeader)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setSleepTime(this.getDefaultSleepTime());
        int column = source.columnAtPoint(p);
        this.setColumnIndex(column);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JTableHeaderMouseEventData data = (JTableHeaderMouseEventData)o;
        return data.getColumnIndex() == this.getColumnIndex();
    }

    public int hashCode() {
        return super.hashCode() + this.m_columnIndex;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JTableHeaderMouseEventData");
        e.setAttribute("column", "" + this.getColumnIndex());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        Rectangle headerRect = this.m_header.getHeaderRect(this.m_columnIndex);
        if (testCase != null) {
            testCase.pauseAWT();
        }
        Point p = this.calculatePoint(headerRect);
        if (!this.m_header.getVisibleRect().contains(p)) {
            Rectangle tvr = this.m_header.getTable().getVisibleRect();
            Rectangle rect = new Rectangle(p.x - (int)(tvr.getWidth() / 2.0), (int)tvr.getY(), (int)tvr.getWidth(), (int)tvr.getHeight());
            this.m_header.getTable().scrollRectToVisible(rect);
        }
        Point screen = this.m_header.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" column: " + this.getColumnIndex());
        return buf.toString();
    }
}

