/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.verifier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;

public class MobyServiceComparator {
    private boolean isDifferent;
    private StringBuffer buffer = null;

    public MobyServiceComparator() {
        this.init();
    }

    private void init() {
        this.isDifferent = false;
        this.buffer = new StringBuffer();
    }

    public boolean areServicesDifferent(MobyService service1, MobyService service2) {
        this.init();
        if (service1 == null || service2 == null) {
            return true;
        }
        if (!service1.getName().equals(service2.getName())) {
            this.addDifference("Service1 has name '" + service1.getName() + "' which is different from '" + service2.getName() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getAuthority().equals(service2.getAuthority())) {
            this.addDifference("Service1 has authority '" + service1.getAuthority() + "' which is different from '" + service2.getAuthority() + "'.");
            this.isDifferent = true;
        }
        if (service1.isAuthoritative() != service2.isAuthoritative()) {
            this.addDifference("Service1 is '" + (service1.isAuthoritative() ? "" : "not ") + "authoritative' while service2 is" + (service2.isAuthoritative() ? "." : " not."));
            this.isDifferent = true;
        }
        if (!service1.getCategory().equals(service2.getCategory())) {
            this.addDifference("Service1 has category '" + service1.getCategory() + "' which is different from '" + service2.getCategory() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getDescription().equals(service2.getDescription())) {
            this.addDifference("Service1 has description '" + service1.getDescription() + "' which is different from '" + service2.getDescription() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getEmailContact().equals(service2.getEmailContact())) {
            this.addDifference("Service1 has contact address '" + service1.getEmailContact() + "' which is different from '" + service2.getEmailContact() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getSignatureURL().equals(service2.getSignatureURL())) {
            this.addDifference("Service1 has signature url '" + service1.getSignatureURL() + "' which is different from '" + service2.getSignatureURL() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getType().equals(service2.getType())) {
            this.addDifference("Service1 has type '" + service1.getType() + "' which is different from '" + service2.getType() + "'.");
            this.isDifferent = true;
        }
        if (!service1.getURL().equals(service2.getURL())) {
            this.addDifference("Service1 has service url '" + service1.getURL() + "' which is different from '" + service2.getURL() + "'.");
            this.isDifferent = true;
        }
        Map primaryInputs1 = this.getMapFromMobyData((MobyData[])service1.getPrimaryInputs());
        Map primaryInputs2 = this.getMapFromMobyData((MobyData[])service2.getPrimaryInputs());
        this.compareMobyDataMaps(primaryInputs1, primaryInputs2, true);
        primaryInputs1 = null;
        primaryInputs2 = null;
        Map secondaryInputs1 = this.getMapFromMobyData((MobyData[])service1.getSecondaryInputs());
        Map secondaryInputs2 = this.getMapFromMobyData((MobyData[])service2.getSecondaryInputs());
        this.compareMobyDataMaps(secondaryInputs1, secondaryInputs2, true);
        secondaryInputs1 = null;
        secondaryInputs2 = null;
        Map outputs1 = this.getMapFromMobyData((MobyData[])service1.getPrimaryOutputs());
        Map outputs2 = this.getMapFromMobyData((MobyData[])service2.getPrimaryOutputs());
        this.compareMobyDataMaps(outputs1, outputs2, false);
        outputs1 = null;
        outputs2 = null;
        return this.isDifferent;
    }

    private void compareMobyDataMaps(Map dataMap1, Map dataMap2, boolean isInput) {
        for (String key : dataMap1.keySet()) {
            if (dataMap2.containsKey(key)) {
                MobyData data1 = (MobyData)dataMap1.get(key);
                MobyData data2 = (MobyData)dataMap2.remove(key);
                if (data1 instanceof MobyPrimaryDataSet) {
                    MobyPrimaryDataSet set1 = (MobyPrimaryDataSet)data1;
                    MobyPrimaryDataSet set2 = (MobyPrimaryDataSet)data2;
                    Map collectionInputs1 = this.getMapFromCollection(set1.getElements());
                    Map collectionInputs2 = this.getMapFromCollection(set2.getElements());
                    for (String inputKey : collectionInputs1.keySet()) {
                        if (collectionInputs2.containsKey(inputKey)) {
                            MobyPrimaryDataSimple colData1 = (MobyPrimaryDataSimple)collectionInputs1.get(inputKey);
                            MobyPrimaryDataSimple colData2 = (MobyPrimaryDataSimple)collectionInputs2.remove(inputKey);
                            if (colData1.getDataType().getName().equals(colData2.getDataType().getName())) {
                                Map namespaces1 = this.getMapFromMobyNamespace(colData1.getNamespaces());
                                Map namespaces2 = this.getMapFromMobyNamespace(colData2.getNamespaces());
                                for (String nsKey : namespaces1.keySet()) {
                                    if (namespaces2.remove(nsKey) != null) continue;
                                    this.addDifference("A collection " + (isInput ? "input" : "output") + " for service2 did not have the namespace '" + nsKey + "'.");
                                    this.isDifferent = true;
                                }
                                for (String nsKey : namespaces2.keySet()) {
                                    this.addDifference("A collection " + (isInput ? "input" : "output") + " for service2 had the additional namespace: '" + nsKey + "'");
                                    this.isDifferent = true;
                                }
                                continue;
                            }
                            this.addDifference("Service1 had an " + (isInput ? "input" : "output") + " in a collection of type '" + colData1.getDataType().getName() + "' while service2 had an " + (isInput ? "input" : "output") + " of type '" + colData2.getDataType().getName() + "'. Both had an articlename of '" + inputKey + "'.");
                            this.isDifferent = true;
                            continue;
                        }
                        this.addDifference("Service1 had a collection " + (isInput ? "input" : "output") + " named '" + inputKey + "' while service2 did not.");
                        this.isDifferent = true;
                    }
                    Iterator collectionInputIt = collectionInputs2.keySet().iterator();
                    while (collectionInputIt.hasNext()) {
                        this.addDifference("Service2 had a collection " + (isInput ? "input" : "output") + " named '" + (String)collectionInputIt.next() + "' while service1 did not.");
                        this.isDifferent = true;
                    }
                    continue;
                }
                if (data1 instanceof MobyPrimaryDataSimple) {
                    if (((MobyPrimaryDataSimple)data1).getDataType().getName().equals(((MobyPrimaryDataSimple)data2).getDataType().getName())) {
                        Map namespaces1 = this.getMapFromMobyNamespace(((MobyPrimaryDataSimple)data1).getNamespaces());
                        Map namespaces2 = this.getMapFromMobyNamespace(((MobyPrimaryDataSimple)data2).getNamespaces());
                        for (String nsKey : namespaces1.keySet()) {
                            if (namespaces2.remove(nsKey) != null) continue;
                            this.addDifference("An " + (isInput ? "input" : "output") + " for service2 did not have the namespace '" + nsKey + "'.");
                            this.isDifferent = true;
                        }
                        for (String nsKey : namespaces2.keySet()) {
                            this.addDifference("An " + (isInput ? "input" : "output") + " for service2 had the additional namespace: '" + nsKey + "'.");
                            this.isDifferent = true;
                        }
                        continue;
                    }
                    this.addDifference("Service1 had an " + (isInput ? "input" : "output") + " of type '" + ((MobyPrimaryDataSimple)data1).getDataType().getName() + "' while service2 had an " + (isInput ? "input" : "output") + " of type '" + ((MobyPrimaryDataSimple)data2).getDataType().getName() + "'. Both had an articlename of '" + key + "'.");
                    this.isDifferent = true;
                    continue;
                }
                if (!(data1 instanceof MobySecondaryData)) continue;
                MobySecondaryData secondary1 = (MobySecondaryData)data1;
                MobySecondaryData secondary2 = (MobySecondaryData)data2;
                if (secondary1.getDataType().equals(secondary2.getDataType())) {
                    if (!secondary1.getMaxValue().equals(secondary2.getMaxValue())) {
                        this.addDifference("Service1 had a secondary input maxinmum value '" + secondary1.getMaxValue() + "' while service2 had a secondary input maximum value of '" + secondary2.getMaxValue() + "'. Both had an articlename of '" + key + "'.");
                        this.isDifferent = true;
                    }
                    if (!secondary1.getMinValue().equals(secondary2.getMinValue())) {
                        this.addDifference("Service1 had a secondary input mininmum value of '" + secondary1.getMinValue() + "' while service2 had a secondary input minimum value of '" + secondary2.getMinValue() + "'. Both had an articlename of '" + key + "'.");
                        this.isDifferent = true;
                    }
                    if (!secondary1.getDefaultValue().equals(secondary2.getDefaultValue())) {
                        this.addDifference("Service1 had a secondary input default value of '" + secondary1.getDefaultValue() + "' while service2 had a secondary input default value of '" + secondary2.getDefaultValue() + "'. Both had an articlename of '" + key + "'.");
                        this.isDifferent = true;
                    }
                    if (!secondary1.getDescription().equals(secondary2.getDescription())) {
                        this.addDifference("Service1 had a secondary input description of '" + secondary1.getDescription() + "' while service2 had a secondary input description of '" + secondary2.getDescription() + "'. Both had an articlename of '" + key + "'.");
                        this.isDifferent = true;
                    }
                    Map allowable1 = this.getMapStrings(secondary1.getAllowedValues());
                    Map allowable2 = this.getMapStrings(secondary2.getAllowedValues());
                    for (String valueKey : allowable1.keySet()) {
                        if (allowable2.remove(valueKey) != null) continue;
                        this.addDifference("A secondary input for service2 did not have the allowable value of '" + valueKey + "'.");
                        this.isDifferent = true;
                    }
                    for (String valueKey : allowable2.keySet()) {
                        this.addDifference("A secondary input for service2 had the additional allowable value: '" + valueKey + "'");
                        this.isDifferent = true;
                    }
                    continue;
                }
                this.addDifference("Service1 had a secondary input of type '" + secondary1.getDataType() + "' while service2 had a secondary input of type " + secondary2.getDataType() + ". Both had an articlename of '" + key + "'.");
                this.isDifferent = true;
                continue;
            }
            this.addDifference("Service1 had an " + (isInput ? "input" : "output") + " named '" + key + "' while service2 did not.");
            this.isDifferent = true;
        }
        Iterator it = dataMap2.keySet().iterator();
        while (it.hasNext()) {
            this.addDifference("Service2 had an " + (isInput ? "input" : "output") + " named '" + (String)it.next() + "' while service1 did not.");
            this.isDifferent = true;
        }
    }

    private Map getMapFromCollection(MobyPrimaryDataSimple[] elements) {
        HashMap<String, MobyPrimaryDataSimple> map = new HashMap<String, MobyPrimaryDataSimple>();
        for (int i = 0; i < elements.length; ++i) {
            map.put(elements[i].getDataType().getName(), elements[i]);
        }
        return map;
    }

    private Map getMapFromMobyData(MobyData[] datas) {
        HashMap<String, MobyData> map = new HashMap<String, MobyData>();
        for (int i = 0; i < datas.length; ++i) {
            MobyData data = datas[i];
            if (data instanceof MobyPrimaryDataSimple) {
                map.put("Simple:" + data.getName(), data);
                continue;
            }
            if (data instanceof MobyPrimaryDataSet) {
                map.put("Collection:" + data.getName(), data);
                continue;
            }
            if (!(data instanceof MobySecondaryData)) continue;
            map.put("Secondary:" + data.getName(), data);
        }
        return map;
    }

    public boolean areInputsOutputsForServiceValid(MobyService service) {
        boolean b = this.areInputsOutputsForServiceValid((MobyData[])service.getPrimaryInputs());
        b = b && this.areInputsOutputsForServiceValid((MobyData[])service.getSecondaryInputs());
        b = b && this.areInputsOutputsForServiceValid((MobyData[])service.getPrimaryOutputs());
        return b;
    }

    private boolean areInputsOutputsForServiceValid(MobyData[] datas) {
        for (int i = 0; i < datas.length; ++i) {
            MobyData data = datas[i];
            if (!data.getName().equals("")) continue;
            return false;
        }
        return true;
    }

    private Map getMapFromMobyNamespace(MobyNamespace[] datas) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < datas.length; ++i) {
            map.put(datas[i].getName(), "");
        }
        return map;
    }

    private Map getMapStrings(String[] datas) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < datas.length; ++i) {
            map.put(datas[i], "");
        }
        return map;
    }

    private void addDifference(String difference) {
        this.buffer.append("\t" + difference + System.getProperty("line.separator"));
    }

    public String getDifferences() {
        return this.buffer.toString();
    }

    public String getServiceErrors(MobyService s) {
        int i;
        StringBuffer sb = new StringBuffer();
        String newline = System.getProperty("line.separator");
        if (s.getName().trim().equals("")) {
            sb.append("\tService name was not found." + newline);
        }
        if (s.getAuthority().trim().equals("")) {
            sb.append("\tService authority was not found." + newline);
        }
        if (s.getCategory().trim().equals("")) {
            sb.append("\tService category was not found." + newline);
        }
        if (s.getDescription().trim().equals("")) {
            sb.append("\tService description was not found." + newline);
        }
        if (s.getEmailContact().trim().equals("")) {
            sb.append("\tService contact email was not found." + newline);
        }
        if (s.getServiceType().getName().trim().equals("")) {
            sb.append("\tService type name was not found." + newline);
        }
        if (s.getPrimaryInputs().length == 0 && s.getPrimaryOutputs().length == 0) {
            sb.append("\tService didn't have an input and or output defined." + newline);
        }
        MobyPrimaryData[] datas = s.getPrimaryInputs();
        for (int i2 = 0; i2 < datas.length; ++i2) {
            if (!(datas[i2] instanceof MobyPrimaryData) || !datas[i2].getName().trim().equals("")) continue;
            sb.append("\tService input, of type " + datas[i2].getDataType().getName() + ", had an empty articlename." + newline);
        }
        datas = null;
        MobySecondaryData[] secondaries = s.getSecondaryInputs();
        for (i = 0; i < secondaries.length; ++i) {
            if (!secondaries[i].getName().trim().equals("")) continue;
            sb.append("\tService secondary input, of type " + secondaries[i].getDataType() + ", had an empty articlename." + newline);
        }
        secondaries = null;
        datas = s.getPrimaryOutputs();
        for (i = 0; i < datas.length; ++i) {
            if (!(datas[i] instanceof MobyPrimaryData) || !datas[i].getName().trim().equals("")) continue;
            sb.append("\tService output, of type " + datas[i].getDataType().getName() + ", had an empty articlename." + newline);
        }
        datas = null;
        return sb.toString();
    }
}

