/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.biomoby.registry.rdfagent.util.Log;

public class Report {
    private StringBuffer buffer = new StringBuffer();
    private String email = "";
    private String admin = "";
    private String registry = "";

    public Report(String administrator, String email, String registry, boolean removed) {
        this.admin = administrator;
        this.email = email;
        this.registry = registry;
        this.init(removed);
    }

    private void init(boolean removed) {
        this.addToReport("");
        this.addToReport("Date: " + new GregorianCalendar().getTime().toString());
        this.addToReport("");
        this.addToReport("This report was generated by the registry located at");
        this.addToReport("\t" + this.registry + ".");
        if (removed) {
            this.addToReport("\tThis report outlines the reason(s) that your service may");
            this.addToReport("have either been removed or is at risk of removal.");
            this.addToReport("");
        } else {
            this.addToReport("\tThis report is only an informative message, letting you know");
            this.addToReport("that your service was found to be modified recently.");
        }
        this.addToReport("");
        this.addToReport("\tIf your service has been removed, enclosed in this report you");
        this.addToReport("will find an RDF document describing the offending service.");
        this.addToReport("This document can be used to re-register your service, so");
        this.addToReport("long as you have 'fixed' any problems associated it.");
        this.addToReport("");
        this.addToReport("\tFor instance, if your service didn't conform to the API,");
        this.addToReport("the most likely reason is that you have inputs or outputs");
        this.addToReport("that do not have article names associated with them.");
        this.addToReport("Other problems include, but aren't limited to, non-existing");
        this.addToReport("signature urls, empty required fields, etc. A common problem");
        this.addToReport("is that some people have RDF documents that contain illegal");
        this.addToReport("RDF-XML. If you suspect that your service description contains");
        this.addToReport("illegal RDF-XML, a useful validating site is:");
        this.addToReport("");
        this.addToReport("\t\thttp://www.w3.org/RDF/Validator/ which validates structure of the RDF");
        this.addToReport("\t\t\t\t\tor");
        this.addToReport("\t\thttp://bioinfo.icapture.ubc.ca/ekawas/agent/RDFAgent_test.html which checks the");
        this.addToReport("\t\tcontained services");
        this.addToReport("");
        this.addToReport("\tHere you can enter your RDF and the servlet will parse it");
        this.addToReport("and tell you what was wrong. If you aren't up to debugging RDF,");
        this.addToReport("you could always re-register your service using Dashboard, ");
        this.addToReport("or an online service registration applet, etc.");
        this.addToReport("");
        this.addToReport("\tPlease don't hesitate to email the moby list if you have");
        this.addToReport("other problems!");
        this.addToReport("");
        this.addToReport("Cheers!");
        this.addToReport("");
        this.addToReport(this.admin);
        this.addToReport(this.email);
        this.addToReport("");
        this.addToReport("");
    }

    public void addToReport(String string) {
        this.buffer.append(string + System.getProperty("line.separator"));
    }

    public String getReport() {
        return this.buffer.toString();
    }

    public boolean saveReport(String directory, String filename) {
        File file = new File(directory, filename);
        if (file.exists()) {
            try {
                Log.info("Attempting to append to an existing report");
                BufferedWriter out = new BufferedWriter(new FileWriter(file, true));
                out.write(System.getProperty("line.separator"));
                out.write(this.getReport());
                out.close();
                Log.info("Successfully saved the report to " + directory + filename + ".");
                return true;
            }
            catch (IOException e) {
                Log.exception(this.getClass().getName(), "saveReport(String, String)", e);
                Log.severe(e.getLocalizedMessage());
                Log.info("Couldn't save report. Agent attempted to append to an existing report and failed.");
                return false;
            }
        }
        try {
            Log.info("Attempting to save the report to " + directory + filename + ".");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(this.getReport());
            out.close();
            Log.info("Successfully saved the report.");
            return true;
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "saveReport(String, String)", e);
            Log.severe(e.getLocalizedMessage());
            Log.info("Couldn't save report. Agent attempted to create a new report and failed.");
            return false;
        }
    }
}

