/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.biomoby.shared.Utils;

public class Log {
    private static Logger logger = null;
    private static boolean isInit = false;
    private static Level level = Level.INFO;
    public static final Level ALL = Level.ALL;
    public static final Level INFO = Level.INFO;
    public static final Level WARN = Level.WARNING;
    public static final Level SEVERE = Level.SEVERE;
    private static boolean enabled = true;

    private static void setLogLevel(Level logLevel) {
        level = logLevel;
        logger.setLevel(logLevel);
        Log.info("Logging level set to " + logLevel.getName());
    }

    private static void init(String path) {
        logger = Logger.getLogger("org.biomoby.registry.rdfagent");
        if (isInit) {
            return;
        }
        isInit = true;
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            String logDirectory = path;
            String logFile = "AgentLog-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(1) + "-" + calendar.get(11) + "_" + calendar.get(12);
            FileHandler fh = new FileHandler(logDirectory + logFile + ".log", true);
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start(String logPath, Level level, boolean enable, String msg) {
        enabled = enable;
        if (enabled) {
            Log.init(logPath);
            Log.info(msg);
            Log.setLogLevel(level);
        }
    }

    public static void stop(String msg) {
        if (enabled) {
            logger.setLevel(INFO);
            Log.info(msg);
        }
    }

    public static void warning(String msg) {
        if (enabled && logger.isLoggable(WARN)) {
            logger.warning(Utils.format((Object)(System.getProperty("line.separator") + "\t" + msg + System.getProperty("line.separator")), (int)3));
        }
    }

    public static void info(String msg) {
        if (enabled && logger.isLoggable(INFO)) {
            logger.info(Utils.format((Object)(System.getProperty("line.separator") + "\t" + msg + System.getProperty("line.separator")), (int)3));
        }
    }

    public static void severe(String msg) {
        if (enabled && logger.isLoggable(SEVERE)) {
            logger.severe(Utils.format((Object)(System.getProperty("line.separator") + "\t" + msg + System.getProperty("line.separator")), (int)3));
        }
    }

    public static void exception(String cls, String method, Throwable t) {
        if (enabled) {
            logger.throwing(cls, method, t);
        }
    }

    public static boolean isLoggable() {
        return logger != null;
    }

    public static void setEnabled(boolean enabled) {
        Log.enabled = enabled;
    }
}

