/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import org.biomoby.registry.properties.MobyProperties;
import org.biomoby.registry.rdfagent.util.Log;

public class Constants {
    private static final String AGENT_HOME = "RDFagent.home";
    public static final String CONFIG_FILE = "RDFagent_config.txt";
    public static String RDFagentHome;
    public static String ADMIN_NAME;
    public static String ADMIN_EMAIL;
    public static String REGISTRY_URL;
    public static String REGISTRY_URI;
    public static String REGISTRY_CONF_FILE;
    public static boolean REGISTRY_IGNORE_NULL;
    public static String REGISTRY_KEYPHRASE;
    public static boolean SMTP_ENABLE;
    public static String SMTP_SERVER;
    public static String SMTP_LOGIN;
    public static String SMTP_PSWD;
    public static boolean LOG_ENABLE;
    public static Level LOG_LEVEL;
    public static boolean REGISTRY_ENABLE_DEREGISTER;
    public static boolean REGISTRY_ENABLE_DEREGISTER_FROM_URL;
    public static boolean REGISTRY_ENABLE_SERVICE_UPDATES;
    public static int REGISTRY_DEREGISTER_COUNT;
    public static boolean REGISTRY_EMAIL;
    public static String LOGFILE_PATH;
    public static String REGISTRY_REMOVAL_ENDPOINT;
    public static String REGISTRY_REMOVAL_URI;
    public static String REGISTRY_REMOVAL_USERNAME;
    public static String REGISTRY_REMOVAL_PASSWORD;

    private static boolean extractBoolean(String bool) {
        if (bool == null) {
            System.err.println("An empty value was found where a yes or no was expected in the config file." + System.getProperty("line.separator") + "  Please ensure that all values in the config file are entered correctly.");
            System.exit(1);
        }
        return (bool = bool.trim()).equalsIgnoreCase("yes") || bool.equalsIgnoreCase("true") || bool.equalsIgnoreCase("1");
    }

    private static int extractInt(String integer) {
        if (integer == null) {
            System.err.println("An empty value was found where an integer was expected in the config file." + System.getProperty("line.separator") + "  Please ensure that all values in the config file are entered correctly.");
            System.exit(1);
        }
        integer = integer.trim();
        int count = 3;
        try {
            count = Integer.parseInt(integer);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid count specified as a property with key: registry.count." + System.getProperty("line.separator") + "Defaulting to 3.");
        }
        return count;
    }

    private static Level extractLogLevel(String level) {
        if (level == null) {
            System.err.println("An empty value was found where an info, warn or severe was expected in the config file." + System.getProperty("line.separator") + "  Please ensure that all values in the config file are entered correctly.");
            System.exit(1);
        }
        if ((level = level.trim()).equalsIgnoreCase("info")) {
            return Log.INFO;
        }
        if (level.equalsIgnoreCase("all")) {
            return Log.ALL;
        }
        if (level.equalsIgnoreCase("warn")) {
            return Log.WARN;
        }
        if (level.equalsIgnoreCase("severe")) {
            return Log.SEVERE;
        }
        return Log.INFO;
    }

    static {
        File dir;
        ADMIN_NAME = null;
        ADMIN_EMAIL = null;
        REGISTRY_URL = null;
        REGISTRY_URI = null;
        REGISTRY_CONF_FILE = null;
        REGISTRY_IGNORE_NULL = false;
        REGISTRY_KEYPHRASE = null;
        SMTP_ENABLE = false;
        SMTP_SERVER = null;
        SMTP_LOGIN = null;
        SMTP_PSWD = null;
        LOG_ENABLE = true;
        LOG_LEVEL = null;
        REGISTRY_ENABLE_DEREGISTER = false;
        REGISTRY_ENABLE_DEREGISTER_FROM_URL = false;
        REGISTRY_ENABLE_SERVICE_UPDATES = false;
        REGISTRY_DEREGISTER_COUNT = 3;
        REGISTRY_EMAIL = true;
        LOGFILE_PATH = null;
        REGISTRY_REMOVAL_ENDPOINT = null;
        REGISTRY_REMOVAL_URI = null;
        REGISTRY_REMOVAL_USERNAME = null;
        REGISTRY_REMOVAL_PASSWORD = null;
        RDFagentHome = System.getProperty(AGENT_HOME);
        if (RDFagentHome == null || RDFagentHome.equals("")) {
            System.err.println("The property 'RDFagent.home' was not specified at runtime. " + System.getProperty("line.separator") + "Please ensure that you specify this property. " + System.getProperty("line.separator") + "If you do not know how to continue, please contact the Moby mailing list.");
            System.exit(1);
        }
        if (!(RDFagentHome.endsWith("/") && RDFagentHome.endsWith("\\") && RDFagentHome.endsWith(System.getProperty("file.separator")))) {
            RDFagentHome = RDFagentHome + System.getProperty("file.separator");
        }
        String str = RDFagentHome + CONFIG_FILE;
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(str);
        }
        catch (FileNotFoundException e) {
            System.err.println("The config file @ " + str + " was not found. Please ensure that it is placed where you said it would be." + System.getProperty("line.separator") + "Full message:" + System.getProperty("line.separator") + e.getLocalizedMessage());
            System.exit(1);
        }
        try {
            prop.load(fis);
        }
        catch (IOException e) {
            System.err.println("The config file @ " + str + " caused an I/O error. Please try again. " + System.getProperty("line.separator") + "Full message:" + System.getProperty("line.separator") + e.getLocalizedMessage());
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println("The config file @ " + str + " contained a malformed Unicode escape sequence. Please try again. " + System.getProperty("line.separator") + "Full message:" + System.getProperty("line.separator") + e.getLocalizedMessage());
            System.exit(1);
        }
        ADMIN_NAME = prop.getProperty("admin.name");
        ADMIN_EMAIL = prop.getProperty("admin.email");
        REGISTRY_URL = prop.getProperty("admin.registry.url");
        REGISTRY_URI = prop.getProperty("admin.registry.uri");
        REGISTRY_CONF_FILE = prop.getProperty("admin.registry.conf");
        REGISTRY_IGNORE_NULL = Constants.extractBoolean(prop.getProperty("admin.registry.ignore.null"));
        REGISTRY_KEYPHRASE = prop.getProperty("admin.registry.removal.keyphrase");
        SMTP_ENABLE = Constants.extractBoolean(prop.getProperty("admin.mail.smtp.enable"));
        SMTP_SERVER = prop.getProperty("admin.mail.smtp.server");
        SMTP_LOGIN = prop.getProperty("admin.mail.smtp.login");
        SMTP_PSWD = prop.getProperty("admin.mail.smtp.password");
        LOG_ENABLE = Constants.extractBoolean(prop.getProperty("log.enable"));
        LOG_LEVEL = Constants.extractLogLevel(prop.getProperty("log.level"));
        REGISTRY_ENABLE_DEREGISTER = Constants.extractBoolean(prop.getProperty("registry.deregister"));
        REGISTRY_ENABLE_DEREGISTER_FROM_URL = Constants.extractBoolean(prop.getProperty("registry.deregister.from_url"));
        REGISTRY_ENABLE_SERVICE_UPDATES = Constants.extractBoolean(prop.getProperty("registry.update.services"));
        REGISTRY_DEREGISTER_COUNT = Constants.extractInt(prop.getProperty("registry.count"));
        REGISTRY_EMAIL = Constants.extractBoolean(prop.getProperty("registry.email"));
        LOGFILE_PATH = prop.getProperty("agent.log.directory");
        REGISTRY_REMOVAL_ENDPOINT = prop.getProperty("admin.registry.removal.endpoint");
        REGISTRY_REMOVAL_URI = prop.getProperty("admin.registry.removal.uri");
        REGISTRY_REMOVAL_USERNAME = prop.getProperty("admin.registry.removal.username");
        REGISTRY_REMOVAL_PASSWORD = prop.getProperty("admin.registry.removal.password");
        if (LOGFILE_PATH == null) {
            LOGFILE_PATH = RDFagentHome + "logs/";
        }
        if (!(LOGFILE_PATH.endsWith("/") && LOGFILE_PATH.endsWith("\\") && LOGFILE_PATH.endsWith(System.getProperty("file.separator")))) {
            LOGFILE_PATH = LOGFILE_PATH + System.getProperty("file.separator");
        }
        if (!(dir = new File(LOGFILE_PATH)).exists()) {
            dir.mkdirs();
        }
        if (!dir.canWrite()) {
            System.err.println("Agent cannot write to the directory: " + dir.getAbsolutePath() + "." + System.getProperty("line.separator") + "Please set up the appropriate permissions for that directory.");
            System.exit(1);
        }
        if (REGISTRY_ENABLE_DEREGISTER || !REGISTRY_IGNORE_NULL || REGISTRY_ENABLE_DEREGISTER_FROM_URL) {
            if (REGISTRY_KEYPHRASE == null) {
                System.err.println("The keyphrase was missing from the config file." + System.getProperty("line.separator") + "This phrase is important for service deregistration.");
                System.exit(1);
            }
            if (REGISTRY_REMOVAL_ENDPOINT == null || REGISTRY_REMOVAL_ENDPOINT.trim().equals("")) {
                System.err.println("The endpoint for Central Admin was missing from the config file." + System.getProperty("line.separator") + "This endpoint is necessary for service deregistration.");
                System.exit(1);
            }
            if (REGISTRY_REMOVAL_URI == null || REGISTRY_REMOVAL_URI.trim().equals("")) {
                System.err.println("The URI for Central Admin was missing from the config file." + System.getProperty("line.separator") + "This URI is necessary for service deregistration.");
                System.exit(1);
            }
            if (REGISTRY_REMOVAL_PASSWORD == null) {
                System.err.println("The password for access to Central Admin was missing from the config file." + System.getProperty("line.separator") + "This password is necessary for service deregistration.");
                System.exit(1);
            }
            if (REGISTRY_REMOVAL_USERNAME == null) {
                System.err.println("The username for access to Central Admin was missing from the config file." + System.getProperty("line.separator") + "This username is necessary for service deregistration.");
                System.exit(1);
            }
        }
        if (REGISTRY_CONF_FILE == null || REGISTRY_CONF_FILE.trim().equals("") || REGISTRY_URL == null || REGISTRY_URL.trim().equals("") || REGISTRY_URI == null || REGISTRY_URI.trim().equals("")) {
            Properties p = MobyProperties.PROPERTIES();
            if (p.getProperty("MOBY_CENTRAL_CONFIG") != null) {
                REGISTRY_CONF_FILE = p.getProperty("MOBY_CENTRAL_CONFIG");
            } else {
                System.err.println("The property specifying the location of the mobycentral.config file is missing." + System.getProperty("line.separator") + "Please fix this in the configuration file.");
                System.exit(1);
            }
            if (p.getProperty("MOBY_SERVER") != null) {
                REGISTRY_URL = p.getProperty("MOBY_SERVER");
            } else {
                System.err.println("The property specifying the mobycentral server url for your registry is missing." + System.getProperty("line.separator") + "Please fix this in the configuration file.");
                System.exit(1);
            }
            if (p.getProperty("MOBY_URI") != null) {
                REGISTRY_URI = p.getProperty("MOBY_URI");
            } else {
                System.err.println("The property specifying the mobycentral endpoint for your registry is missing." + System.getProperty("line.separator") + "Please fix this in the configuration file.");
                System.exit(1);
            }
        }
        System.setProperty("MOBY_URI", REGISTRY_URI);
        System.setProperty("MOBY_CENTRAL_CONFIG", REGISTRY_CONF_FILE);
        System.setProperty("MOBY_SERVER", REGISTRY_URL);
        if (REGISTRY_EMAIL) {
            if (SMTP_ENABLE) {
                if (SMTP_SERVER == null || SMTP_SERVER.trim().equals("")) {
                    System.err.println("The SMTP server address is missing in the config file." + System.getProperty("line.separator") + "Please fix this in the configuration file or disable SMTP mailing.");
                    System.exit(1);
                }
                if (SMTP_LOGIN == null) {
                    SMTP_LOGIN = "";
                    System.err.println("No SMTP login information found in config file. Using '' as the login.");
                }
                if (SMTP_PSWD == null) {
                    SMTP_PSWD = "";
                    System.err.println("No SMTP password found in config file. Using '' as the password.");
                }
            }
            if (ADMIN_EMAIL == null || ADMIN_EMAIL.trim().equals("")) {
                System.err.println("The mobycentral registry administrator's email address was missing from the config file." + System.getProperty("line.separator") + "Please fix this in the configuration file.");
                System.exit(1);
            }
            if (ADMIN_NAME == null || ADMIN_NAME.trim().equals("")) {
                System.err.println("The mobycentral registry administrator's name was missing from the config file." + System.getProperty("line.separator") + "Please fix this in the configuration file.");
                System.exit(1);
            }
        }
    }
}

