/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import junit.extensions.xml.IXMLTest;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public final class XMLTagResourceBundle {
    private static XMLTagResourceBundle s_singleton;
    private final Map m_map = new HashMap();
    private ResourceBundle m_bundle = ResourceBundle.getBundle("TagMapping");
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$junit$extensions$xml$IXMLTestCase;
    static /* synthetic */ Class class$junit$extensions$xml$IXMLTestSuite;

    private XMLTagResourceBundle() {
    }

    public static AbstractTagHandler getTagHandler(Element element, IXMLTest test, String type) throws XMLException {
        return XMLTagResourceBundle.getSingleton().getTagHandlerImpl(element, test, type);
    }

    public static void addTagHandler(String tagname, String classname) {
        XMLTagResourceBundle.getSingleton().addTagHandlerImpl(tagname, classname);
    }

    public static void removeTagHandler(String tagname) {
        XMLTagResourceBundle.getSingleton().removeTagHandlerImpl(tagname);
    }

    private static XMLTagResourceBundle getSingleton() {
        if (s_singleton == null) {
            s_singleton = new XMLTagResourceBundle();
        }
        return s_singleton;
    }

    private Class getClassFromTag(String tagname, boolean debug) throws XMLException {
        String clazzName = (String)this.m_map.get(tagname);
        if (clazzName == null) {
            clazzName = this.m_bundle.getString(tagname);
            if (clazzName != null && debug) {
                System.err.println("Found tag(" + tagname + "/" + clazzName + ") in properties");
            }
        } else if (debug) {
            System.err.println("Found tag(" + tagname + "/" + clazzName + ") in map");
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            return clazz;
        }
        catch (Exception e) {
            throw new XMLException("Could not load class:" + clazzName, null, null, null);
        }
    }

    private AbstractTagHandler getTagHandlerImpl(Element element, IXMLTest test, String type) throws XMLException {
        Class clazz = this.getClassFromTag(type, test.getDebug());
        Object[] params = new Object[]{element, test};
        try {
            Constructor cnstr;
            if (test instanceof IXMLTestCase) {
                cnstr = clazz.getConstructor(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLTagResourceBundle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, class$junit$extensions$xml$IXMLTestCase == null ? (class$junit$extensions$xml$IXMLTestCase = XMLTagResourceBundle.class$("junit.extensions.xml.IXMLTestCase")) : class$junit$extensions$xml$IXMLTestCase);
            } else if (test instanceof IXMLTestSuite) {
                cnstr = clazz.getConstructor(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLTagResourceBundle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, class$junit$extensions$xml$IXMLTestSuite == null ? (class$junit$extensions$xml$IXMLTestSuite = XMLTagResourceBundle.class$("junit.extensions.xml.IXMLTestSuite")) : class$junit$extensions$xml$IXMLTestSuite);
            } else {
                throw new XMLException("Test is not instanceof IXMLTestSuite or IXMLTestCase");
            }
            return (AbstractTagHandler)cnstr.newInstance(params);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof XMLException) {
                throw (XMLException)t;
            }
            throw new XMLException(t.getMessage(), t, element, null);
        }
        catch (XMLException xmle) {
            throw xmle;
        }
        catch (Exception e) {
            throw new XMLException("Could not create tag handler for:" + type + "\n", (Throwable)e, element, null);
        }
        catch (Error er) {
            throw new XMLException("Could not create tag handler for:" + type + "\n", (Throwable)er, element, null);
        }
    }

    private void addTagHandlerImpl(String tagname, String classname) {
        this.m_map.put(tagname, classname);
    }

    private void removeTagHandlerImpl(String tagname) {
        this.m_map.remove(tagname);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

