/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import junit.extensions.xml.XMLObjectCache;
import junit.extensions.xml.XMLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLException
extends RuntimeException {
    private Element m_element;
    private Throwable m_cause;
    private XMLObjectCache m_properties;

    public XMLException(String msg) {
        this(msg, null, null, null);
    }

    public XMLException(String msg, Element e) {
        this(msg, null, e, null);
    }

    public XMLException(String msg, Throwable cause, Element element, XMLObjectCache properties) {
        super(msg);
        this.m_cause = cause;
        this.m_element = element;
        this.m_properties = properties;
    }

    public Element getElement() {
        return this.m_element;
    }

    public String toString() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(50000);
            PrintWriter pw = new PrintWriter(os);
            pw.println(super.toString());
            XMLWriter xmlw = new XMLWriter(true);
            xmlw.setOutput(pw);
            Element e = this.getElement();
            if (e != null) {
                pw.println("While processing element:");
                xmlw.write(e);
                pw.println();
                Node parent = e.getParentNode();
                if (parent != null) {
                    pw.println("Within:");
                    xmlw.write(parent);
                    pw.println();
                }
                if (this.m_properties != null) {
                    String[] names = this.m_properties.getNames();
                    boolean first = true;
                    for (int i = 0; i < names.length; ++i) {
                        if (names[i] == null || names[i].startsWith("../")) continue;
                        if (first) {
                            pw.println("Local Parameters:");
                            first = false;
                        }
                        Object value = this.m_properties.get(names[i]);
                        pw.println(names[i] + " = " + value);
                    }
                }
            }
            pw.flush();
            os.close();
            return os.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return super.toString();
        }
    }
}

