/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.mrc.hgmp.taverna.retsina;

import com.jgraph.JGraph;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.PortRenderer;
import com.jgraph.graph.PortView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflOutputPort;

public class ScuflOutputPortView
extends PortView {
    public static ImageIcon outputPortIcon = null;
    private static int fontSize = 12;
    private static Font font = new Font("Monospaced", 0, fontSize);
    protected ScuflOutputPortRenderer renderer = new ScuflOutputPortRenderer();

    public ScuflOutputPortView(Object cell, JGraph graph, CellMapper cm) {
        super(cell, graph, cm);
    }

    public Rectangle getBounds() {
        int width = ScuflOutputPortView.getWidth((String)((ScuflOutputPort)((Object)this.cell)).getUserObject());
        Rectangle bounds = new Rectangle(super.getLocation(null));
        int height = this.getHeight();
        bounds.x = bounds.x;
        bounds.y -= height / 2;
        bounds.width = width;
        bounds.height = height;
        return bounds;
    }

    public Point getLocation(EdgeView edge) {
        Point p = super.getLocation(null);
        p.x += ScuflOutputPortView.getWidth((String)((ScuflOutputPort)((Object)this.cell)).getUserObject());
        p.y = p.y - outputPortIcon.getIconHeight() / 2 + 1;
        return p;
    }

    public static int getWidth(String name) {
        JLabel c = new JLabel();
        FontMetrics fm = c.getFontMetrics(font);
        int width = fm.stringWidth(name);
        return width + outputPortIcon.getIconWidth();
    }

    public int getHeight() {
        JLabel c = new JLabel();
        FontMetrics fm = c.getFontMetrics(font);
        return fm.getHeight() + 8;
    }

    public CellViewRenderer getRenderer() {
        return this.renderer;
    }

    static {
        URL outputPortIconURL = ScuflOutputPortView.class.getClassLoader().getResource("images/output.gif");
        outputPortIcon = new ImageIcon(outputPortIconURL);
    }

    public class ScuflOutputPortRenderer
    extends PortRenderer {
        public void paint(Graphics g) {
            String param = (String)((ScuflOutputPort)((Object)ScuflOutputPortView.this.cell)).getUserObject();
            FontMetrics fm = this.getFontMetrics(font);
            int width = fm.stringWidth(param);
            g.setColor(Color.red);
            g.setFont(font);
            g.drawString(param, 0, 12);
            g.setColor(this.graph.getBackground());
            outputPortIcon.paintIcon((Component)this.graph, g, width, 0);
        }
    }
}

