/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.mrc.hgmp.taverna.retsina;

import com.jgraph.JGraph;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultEdge;
import com.jgraph.graph.Edge;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import com.jgraph.plaf.GraphUI;
import com.jgraph.plaf.basic.BasicGraphUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import org.embl.ebi.escience.scufl.ConcurrencyConstraintCreationException;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DataConstraintCreationException;
import org.embl.ebi.escience.scufl.DuplicateConcurrencyConstraintNameException;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.MalformedNameException;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEventPrinter;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scufl.view.XScuflView;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabProcessor;
import org.emboss.jemboss.gui.startup.ProgList;
import uk.ac.mrc.hgmp.taverna.retsina.DataSet;
import uk.ac.mrc.hgmp.taverna.retsina.ProgNode;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphCell;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflInputPort;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflInputPortView;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflOutputPort;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflOutputPortView;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflPort;

public class ScuflGraph
extends JGraph
implements DropTargetListener,
ScuflUIComponent {
    final Cursor cbusy = new Cursor(3);
    final Cursor cdone = new Cursor(0);
    private ScuflModel scuflModel;
    private ProgList progs;
    private XScuflView scuflView;
    private static int fontSize = 12;
    private static Font font = new Font("Monospaced", 0, fontSize);
    private DataSet dataSet = new DataSet();
    private Vector soapLabProcessorNameStore = new Vector();
    protected static Border dropBorder = new BevelBorder(1);
    protected static Border endBorder = BorderFactory.createLineBorder(Color.black);

    public ImageIcon getIcon() {
        return null;
    }

    public ScuflGraph(GraphModel model, ProgList progs) {
        super(model);
        this.progs = progs;
        this.setSelectNewCells(true);
        this.setPortsVisible(true);
        this.setGridEnabled(true);
        this.setGridSize(6);
        this.setTolerance(2);
        this.setDropTarget(new DropTarget((Component)((Object)this), this));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int y;
                int x;
                Port cell;
                if (e.getClickCount() == 2 && (cell = ScuflGraph.this.getPortForLocation(x = e.getX(), y = e.getY())) != null) {
                    String s;
                    String lab = ScuflGraph.this.convertValueToString(cell);
                    String value = null;
                    org.embl.ebi.escience.scufl.Port port = ((ScuflPort)cell).getScuflPort();
                    if (ScuflGraph.this.dataSet.dataContains(port)) {
                        value = ScuflGraph.this.dataSet.getValue(port);
                    }
                    if ((s = JOptionPane.showInputDialog(null, "Value of " + lab, value)) != null) {
                        if (!ScuflGraph.this.dataSet.dataContains(port)) {
                            ScuflGraph.this.dataSet.addData(lab, "string", s, port);
                            try {
                                ScuflPort sip;
                                Processor sinkProcessor = ScuflGraph.this.scuflModel.getWorkflowSinkProcessor();
                                Processor sourceProcessor = ScuflGraph.this.scuflModel.getWorkflowSourceProcessor();
                                InputPort input = null;
                                OutputPort output = null;
                                if (cell instanceof ScuflInputPort) {
                                    sip = (ScuflInputPort)cell;
                                    input = (InputPort)((ScuflInputPort)sip).getScuflPort();
                                    sinkProcessor.addPort(input);
                                    output = new OutputPort(sourceProcessor, lab);
                                    sourceProcessor.addPort(output);
                                } else if (cell instanceof ScuflOutputPort) {
                                    sip = (ScuflOutputPort)cell;
                                    output = (OutputPort)sip.getScuflPort();
                                    sourceProcessor.addPort(output);
                                    input = new InputPort(sinkProcessor, lab);
                                    sinkProcessor.addPort(input);
                                }
                                DataConstraint dc = new DataConstraint(ScuflGraph.this.scuflModel, output, input);
                                ScuflGraph.this.scuflModel.addDataConstraint(dc);
                            }
                            catch (DuplicatePortNameException dpne) {
                                System.out.println("DuplicatePortNameException");
                            }
                            catch (DataConstraintCreationException dce) {
                                System.out.println("DataConstraintCreationException");
                            }
                            catch (PortCreationException pce) {
                                System.out.println("PortCreationException");
                            }
                        } else {
                            ScuflGraph.this.dataSet.setDataValue(lab, s, port);
                        }
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
    }

    public ScuflModel getScuflModel() {
        return this.scuflModel;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public String getToolTipText(MouseEvent e) {
        if (e != null) {
            Object c = this.getPortForLocation(e.getX(), e.getY());
            if (c != null) {
                return this.convertValueToString(c);
            }
            c = this.getFirstCellForLocation(e.getX(), e.getY());
            if (c != null && c instanceof ScuflGraphCell) {
                Processor proc = ((ScuflGraphCell)((Object)c)).getScuflProcessor();
                return proc.getDescription();
            }
        }
        return null;
    }

    public void clearScuflModel() {
        this.scuflModel.clear();
        this.soapLabProcessorNameStore.removeAllElements();
    }

    public void loadXScufl(String xscufl) {
        try {
            XScuflParser.populate(xscufl, this.scuflModel, null);
        }
        catch (UnknownProcessorException upe) {
            System.out.println("loadXScufl::UnknownProcessorException");
        }
        catch (UnknownPortException upte) {
            System.out.println("loadXScufl::UnknownPortException");
        }
        catch (ProcessorCreationException pce) {
            System.out.println("loadXScufl::ProcessorCreationException");
        }
        catch (DataConstraintCreationException dcce) {
            System.out.println("loadXScufl::DataConstraintCreationException");
        }
        catch (DuplicateProcessorNameException dpne) {
            System.out.println("loadXScufl::DuplicateProcessorNameException");
        }
        catch (MalformedNameException mne) {
            System.out.println("loadXScufl::MalformedNameException");
        }
        catch (ConcurrencyConstraintCreationException ccce) {
            System.out.println("loadXScufl::ConcurrencyConstraintCreationException");
        }
        catch (DuplicateConcurrencyConstraintNameException dccne) {
            System.out.println("loadXScufl::DuplicateConcurrencyConstraintNameException");
        }
        catch (XScuflFormatException xfe) {
            System.out.println("loadXScufl::XScuflFormatException");
        }
        Processor[] proc = this.scuflModel.getProcessors();
        int xpos = 0;
        int ypos = 0;
        for (int i = 0; i < proc.length; ++i) {
            Point p = new Point(xpos, ypos += 20);
            xpos += this.insertCell(p, proc[i], proc[i].getName());
            this.soapLabProcessorNameStore.add(proc[i].getName());
        }
        DataConstraint[] dc = this.scuflModel.getDataConstraints();
        Object[] cells = this.getRoots();
        for (int i = 0; i < dc.length; ++i) {
            String constraint = dc[i].getName();
            int ind1 = constraint.indexOf(":");
            int ind2 = constraint.indexOf("'");
            if (ind2 < 0) {
                ind2 = constraint.indexOf("-");
            }
            if (ind1 < 0 || ind2 < 0 || ind1 > ind2) continue;
            String procName = constraint.substring(0, ind1).trim();
            String portName = constraint.substring(ind1 + 1, ind2).trim();
            Port pstart = this.getJGraphPort(procName, portName, cells);
            ind1 = constraint.indexOf("'", ind2 + 1);
            if (ind1 < 0) {
                ind1 = constraint.indexOf(">");
            }
            ind2 = constraint.indexOf(":", ind1);
            procName = constraint.substring(ind1 + 1, ind2).trim();
            portName = constraint.substring(ind2 + 1).trim();
            Port pend = this.getJGraphPort(procName, portName, cells);
            if (pstart == null || pend == null) continue;
            this.connect(pstart, pend);
        }
    }

    private Port getJGraphPort(String procName, String portName, Object[] cells) {
        for (int j = 0; j < cells.length; ++j) {
            if (!((String)((ScuflGraphCell)((Object)cells[j])).getUserObject()).equals(procName)) continue;
            List children = ((ScuflGraphCell)((Object)cells[j])).getChildren();
            for (int k = 0; k < children.size(); ++k) {
                if (!((String)((ScuflPort)((Object)children.get(k))).getUserObject()).equals(portName)) continue;
                return (ScuflPort)((Object)children.get(k));
            }
        }
        return null;
    }

    protected EdgeView createEdgeView(Edge e, CellMapper cm) {
        return new EdgeView(e, this, cm){

            public boolean isAddPointEvent(MouseEvent event) {
                return event.isShiftDown();
            }

            public boolean isRemovePointEvent(MouseEvent event) {
                return event.isShiftDown();
            }
        };
    }

    protected PortView createPortView(Port p, CellMapper cm) {
        if (p instanceof ScuflOutputPort) {
            return new ScuflOutputPortView(p, this, cm);
        }
        return new ScuflInputPortView(p, this, cm);
    }

    public void insertCell(Point point, String group, String name) {
        this.setCursor(this.cbusy);
        try {
            SoaplabProcessor proc = this.addSoaplabProcessor(group, name);
            this.insertCell(point, proc, proc.getName());
        }
        catch (DuplicateProcessorNameException dpne) {
            System.out.println("DuplicateProcessorNameException addProcessor exception thrown");
        }
        catch (Exception exp) {
            System.out.println("addProcessor exception thrown");
            exp.printStackTrace();
        }
        this.setCursor(this.cdone);
    }

    public int insertCell(Point point, Processor proc, String name) {
        ScuflGraphCell vertex = new ScuflGraphCell((Object)name, proc);
        Map map = GraphConstants.createMap();
        JLabel lab = new JLabel(name);
        Dimension size = lab.getPreferredSize();
        int width = (int)size.getWidth() + 10;
        GraphConstants.setBorder((Map)map, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground((Map)map, (Color)Color.orange);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        Hashtable<ScuflGraphCell, Map> attributes = new Hashtable<ScuflGraphCell, Map>();
        if (proc != null) {
            int j;
            int maxPortWidth = 0;
            int wid = 0;
            InputPort[] inPorts = proc.getInputPorts();
            int nports = inPorts.length;
            int height = (int)size.getHeight() + 32 * nports;
            size = new Dimension(width, height);
            for (j = 0; j < nports; ++j) {
                wid = this.getInputPortWidth(inPorts[j]);
                if (wid <= maxPortWidth) continue;
                maxPortWidth = wid;
            }
            width += maxPortWidth;
            point.x += maxPortWidth;
            GraphConstants.setBounds((Map)map, (Rectangle)new Rectangle(point, size));
            attributes.put(vertex, map);
            for (j = 0; j < inPorts.length; ++j) {
                attributes.putAll(vertex.addInputPort(inPorts[j]));
            }
            maxPortWidth = 0;
            OutputPort[] outPorts = proc.getOutputPorts();
            for (int j2 = 0; j2 < outPorts.length; ++j2) {
                attributes.putAll(vertex.addOutputPort(outPorts[j2]));
                wid = this.getOutputPortWidth(outPorts[j2]);
                if (wid <= maxPortWidth) continue;
                maxPortWidth = wid;
            }
            width += maxPortWidth;
        }
        this.getGraphLayoutCache().insert(new Object[]{vertex}, attributes, null, null, null);
        return width;
    }

    public void connect(Port source, Port target) {
        ConnectionSet cs = new ConnectionSet();
        DefaultEdge edge = new DefaultEdge();
        cs.connect((Object)edge, (Object)source, (Object)target);
        Map map = GraphConstants.createMap();
        GraphConstants.setLineEnd((Map)map, (int)2);
        Hashtable<DefaultEdge, Map> attributes = new Hashtable<DefaultEdge, Map>();
        attributes.put(edge, map);
        this.getGraphLayoutCache().insert(new Object[]{edge}, attributes, cs, null, null);
    }

    public int getInputPortWidth(org.embl.ebi.escience.scufl.Port p) {
        String name = p.getName();
        JLabel c = new JLabel();
        FontMetrics fm = c.getFontMetrics(font);
        int width = fm.stringWidth(name);
        return width + ScuflInputPortView.inputPortIcon.getIconWidth();
    }

    public int getOutputPortWidth(org.embl.ebi.escience.scufl.Port p) {
        String name = p.getName();
        JLabel c = new JLabel();
        FontMetrics fm = c.getFontMetrics(font);
        int width = fm.stringWidth(name);
        return width + ScuflOutputPortView.outputPortIcon.getIconWidth();
    }

    public void destroyProcessor(Processor processor) {
        this.scuflModel.destroyProcessor(processor);
    }

    public String getXScufl() {
        return this.scuflView.getXMLText();
    }

    public void addDataConstraint(org.embl.ebi.escience.scufl.Port source_name, org.embl.ebi.escience.scufl.Port sink_name) {
        try {
            DataConstraint dc = new DataConstraint(this.scuflModel, source_name, sink_name);
            this.scuflModel.addDataConstraint(dc);
        }
        catch (DataConstraintCreationException dcce) {
            System.out.println("DataConstraintCreationException:: in addDataConstraint");
        }
    }

    public SoaplabProcessor addSoaplabProcessor(String group, String name) throws DuplicateProcessorNameException, Exception {
        String serviceName = name;
        if (this.soapLabProcessorNameStore.contains(name)) {
            name = this.getUniqueProcessorName(name);
        }
        SoaplabProcessor processor = null;
        String procName = name;
        this.soapLabProcessorNameStore.add(name);
        try {
            processor = new SoaplabProcessor(this.scuflModel, procName, "http://industry.ebi.ac.uk/soap/soaplab/" + group + "::" + serviceName);
            this.scuflModel.addProcessor(processor);
            System.out.println("Finished test : SoaplabProcessorCreation");
        }
        catch (ProcessorCreationException pce) {
            System.out.println("ProcessorCreationException addProcessor exception thrown");
        }
        return processor;
    }

    private String getUniqueProcessorName(String name) {
        int num = 1;
        String newName = name;
        while (this.soapLabProcessorNameStore.contains(newName)) {
            newName = name + num++;
        }
        return newName;
    }

    public void attachToModel(ScuflModel scuflModel) {
        this.scuflModel = scuflModel;
        scuflModel.addListener(new ScuflModelEventPrinter(null));
        this.scuflView = new XScuflView(scuflModel);
    }

    public void detachFromModel() {
    }

    public String getName() {
        return "Retsina";
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor) || e.isDataFlavorSupported(ProgNode.PROGNODE)) {
            e.acceptDrag(3);
            this.setBorder(dropBorder);
        }
    }

    public void dragExit(DropTargetEvent e) {
        this.setBorder(endBorder);
    }

    public void drop(DropTargetDropEvent e) {
        this.setBorder(endBorder);
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrop(3);
            try {
                ProgNode dropS = (ProgNode)t.getTransferData(DataFlavor.stringFlavor);
                System.out.println("DROP DataFlavor.stringFlavor " + dropS.getProgramName());
                String name = dropS.getProgramName();
                String group = this.progs.getProgramGroup(name).toLowerCase().replace(':', '_').replace(' ', '_');
                this.insertCell(e.getLocation(), group, name);
                e.dropComplete(true);
            }
            catch (Exception ex) {}
        } else if (t.isDataFlavorSupported(ProgNode.PROGNODE)) {
            e.acceptDrop(3);
            try {
                ProgNode dropS = (ProgNode)t.getTransferData(ProgNode.PROGNODE);
                System.out.println("DROP ProgNode.PROGNODE " + dropS.getProgramName());
                e.dropComplete(true);
            }
            catch (Exception exception) {}
        } else {
            e.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void updateUI() {
        this.setUI((GraphUI)new DialogUI());
        this.invalidate();
    }

    public class DialogUI
    extends BasicGraphUI {
        Object editingCell;

        public void startEditingAtCell(JGraph graph, Object cell) {
            super.startEditingAtCell(graph, cell);
            this.editingCell = cell;
        }

        protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageGraph) {
            super.completeEditing(messageStop, messageCancel, messageGraph);
            if (this.editingCell != null) {
                Processor p = ((ScuflGraphCell)((Object)this.editingCell)).getScuflProcessor();
                System.out.println("Processor old name " + p.getName());
                System.out.println("Processor new name " + this.editingCell.toString());
            }
        }
    }
}

