/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.talisman.scuflsupport;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.embl.ebi.escience.scufl.ConcurrencyConstraintCreationException;
import org.embl.ebi.escience.scufl.DataConstraintCreationException;
import org.embl.ebi.escience.scufl.DuplicateConcurrencyConstraintNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.MalformedNameException;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scufl.view.DotView;
import org.embl.ebi.escience.talisman.AbortActionException;
import org.embl.ebi.escience.talisman.Action;
import org.embl.ebi.escience.talisman.ActionWorker;
import org.embl.ebi.escience.talisman.Field;
import org.embl.ebi.escience.talisman.NodeResolutionException;
import org.embl.ebi.escience.talisman.Resolver;
import org.embl.ebi.escience.talisman.TalismanNode;
import org.embl.ebi.escience.talisman.Trigger;
import org.embl.ebi.escience.talisman.UnknownResolutionProtocolException;

public class XScufl2Dot
implements ActionWorker {
    public void process(HttpServletRequest request, HttpServletResponse response, Action action) throws AbortActionException, NodeResolutionException, UnknownResolutionProtocolException {
        Trigger trigger = (Trigger)action.getParent();
        action.requireParameters("input,output,ports");
        Field input = Resolver.getField((String)action.props.getProperty("input"), (TalismanNode)action);
        Field output = Resolver.getField((String)action.props.getProperty("output"), (TalismanNode)action);
        String portPolicyString = Resolver.getFieldValue((String)action.props.getProperty("ports"), (TalismanNode)action);
        ScuflModel model = new ScuflModel();
        DotView view = new DotView(model);
        if (portPolicyString.equalsIgnoreCase("all")) {
            view.setPortDisplay(0);
        }
        if (portPolicyString.equalsIgnoreCase("bound")) {
            view.setPortDisplay(1);
        }
        try {
            XScuflParser.populate(input.getValue(), model, null);
            output.setValue(view.getDot());
        }
        catch (UnknownProcessorException proc) {
            trigger.addError(proc.getMessage());
            throw new AbortActionException();
        }
        catch (UnknownPortException port) {
            trigger.addError(port.getMessage());
            throw new AbortActionException();
        }
        catch (ProcessorCreationException pce) {
            trigger.addError(pce.getMessage());
            throw new AbortActionException();
        }
        catch (DataConstraintCreationException dce) {
            trigger.addError(dce.getMessage());
            throw new AbortActionException();
        }
        catch (DuplicateProcessorNameException dpne) {
            trigger.addError(dpne.getMessage());
            throw new AbortActionException();
        }
        catch (MalformedNameException mne) {
            trigger.addError(mne.getMessage());
            throw new AbortActionException();
        }
        catch (XScuflFormatException xsfe) {
            trigger.addError(xsfe.getMessage());
            throw new AbortActionException();
        }
        catch (ConcurrencyConstraintCreationException dce) {
            trigger.addError(dce.getMessage());
            throw new AbortActionException();
        }
        catch (DuplicateConcurrencyConstraintNameException dpne) {
            trigger.addError(dpne.getMessage());
            throw new AbortActionException();
        }
    }
}

