/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.talisman.scuflsupport;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabProcessor;
import org.embl.ebi.escience.talisman.AbortActionException;
import org.embl.ebi.escience.talisman.Action;
import org.embl.ebi.escience.talisman.ActionWorker;
import org.embl.ebi.escience.talisman.NodeResolutionException;
import org.embl.ebi.escience.talisman.Resolver;
import org.embl.ebi.escience.talisman.TalismanNode;
import org.embl.ebi.escience.talisman.Trigger;
import org.embl.ebi.escience.talisman.UnknownResolutionProtocolException;
import org.embl.ebi.escience.talisman.scuflsupport.AbstractScuflAction;

public class AddProcessor
extends AbstractScuflAction
implements ActionWorker {
    public void process(HttpServletRequest request, HttpServletResponse response, Action action) throws AbortActionException, NodeResolutionException, UnknownResolutionProtocolException {
        super.process(request, response, action);
        Trigger trigger = (Trigger)action.getParent();
        action.requireParameters("model,type,spec,name");
        String processorType = Resolver.getFieldValue((String)action.props.getProperty("type"), (TalismanNode)action).toLowerCase();
        String processorSpec = Resolver.getFieldValue((String)action.props.getProperty("spec"), (TalismanNode)action);
        String processorName = Resolver.getFieldValue((String)action.props.getProperty("name"), (TalismanNode)action);
        if (!processorType.equals("soaplabwsdl")) {
            trigger.addError("Only the 'soaplabwsdl' processor type is currently supported, sorry.");
            throw new AbortActionException();
        }
        try {
            this.model.addProcessor(new SoaplabProcessor(this.model, processorName, processorSpec));
        }
        catch (ProcessorCreationException pce) {
            trigger.addError(pce.getMessage());
            throw new AbortActionException();
        }
        catch (DuplicateProcessorNameException dpne) {
            trigger.addError(dpne.getMessage());
            throw new AbortActionException();
        }
    }
}

