/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.wsdl.WSDLBasedProcessor;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class WSDLInvocationTask
implements ProcessorTaskWorker {
    private static Logger logger = Logger.getLogger((Class)WSDLInvocationTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private WSDLBasedProcessor processor;

    public WSDLInvocationTask(Processor p) {
        this.processor = (WSDLBasedProcessor)p;
    }

    public Map execute(Map inputMap, ProcessorTask parentTask) throws TaskExecutionException {
        try {
            WSIFOperation operation = this.processor.getWSIFOperation();
            WSIFMessage input = operation.createInputMessage();
            WSIFMessage output = operation.createOutputMessage();
            WSIFMessage fault = operation.createFaultMessage();
            for (int i = 0; i < this.processor.inNames.length; ++i) {
                Object value = null;
                Class c = this.processor.inTypes[i];
                String argName = this.processor.inNames[i];
                DataThing inputObject = (DataThing)inputMap.get(argName);
                if (inputObject == null) {
                    throw new TaskExecutionException("Input to web service '" + argName + "' was defined but not provided.");
                }
                if (inputObject.getDataObject() instanceof String) {
                    String argString = (String)inputObject.getDataObject();
                    if (c.equals(Double.TYPE)) {
                        value = new Double(argString);
                    } else if (c.equals(Float.TYPE)) {
                        value = new Float(argString);
                    } else if (c.equals(Integer.TYPE)) {
                        value = new Integer(argString);
                    } else if (c.equals(Boolean.TYPE)) {
                        value = new Boolean(argString);
                    }
                }
                if (value == null) {
                    value = inputObject.getDataObject();
                }
                input.setObjectPart(this.processor.inNames[i], value);
            }
            operation.executeRequestResponseOperation(input, output, fault);
            Iterator i = output.getPartNames();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
            HashMap<String, DataThing> resultMap = new HashMap<String, DataThing>();
            for (int i2 = 0; i2 < this.processor.outNames.length; ++i2) {
                String outputName = this.processor.outNames[i2];
                resultMap.put(outputName, new DataThing(output.getObjectPart(outputName)));
            }
            return resultMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TaskExecutionException te = new TaskExecutionException("Error occured during invocation " + ex.getMessage());
            te.initCause(ex);
            throw te;
        }
    }
}

