/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.wsdl;

import [Ljava.lang.String;;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.providers.soap.apacheaxis.WSIFDynamicProvider_ApacheAxis;
import org.apache.wsif.providers.soap.apacheaxis.WSIFPort_ApacheAxis;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.util.WSIFUtils;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.w3c.dom.Element;

public class WSDLBasedProcessor
extends Processor
implements Serializable {
    WSIFPort port = null;
    WSIFService dpf = null;
    String operationName = null;
    String inputName = null;
    String outputName = null;
    String wsdlLocation = null;
    String[] inNames;
    String[] outNames;
    Class[] inTypes;
    Class[] outTypes;
    static /* synthetic */ Class class$java$lang$String;

    public WSDLBasedProcessor(ScuflModel model, String procName, String wsdlLocation, String operationName) throws ProcessorCreationException, DuplicateProcessorNameException {
        this(model, procName, wsdlLocation, operationName, null);
    }

    public WSDLBasedProcessor(ScuflModel model, String procName, String wsdlLocation, String operationName, QName portTypeName) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, procName);
        this.wsdlLocation = wsdlLocation;
        this.operationName = operationName;
        if (this.isOffline()) {
            return;
        }
        WSIFPluggableProviders.overrideDefaultProvider((String)"http://schemas.xmlsoap.org/wsdl/soap/", (WSIFProvider)new WSIFDynamicProvider_ApacheAxis());
        Definition def = null;
        try {
            def = WSIFUtils.readWSDL(null, (String)wsdlLocation);
        }
        catch (Exception ex) {
            ProcessorCreationException pce = new ProcessorCreationException(procName + ": Unable to load wsdl at " + wsdlLocation);
            pce.initCause(ex);
            pce.printStackTrace();
            throw pce;
        }
        try {
            Service service = WSIFUtils.selectService((Definition)def, null, null);
            PortType portType = WSIFUtils.selectPortType((Definition)def, (String)(portTypeName == null ? null : portTypeName.getNamespaceURI()), (String)(portTypeName == null ? null : portTypeName.getLocalPart()));
            WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
            this.dpf = factory.getService(def, service, portType);
            this.port = this.dpf.getPort();
            String inputName = null;
            String outputName = null;
            List operationList = portType.getOperations();
            boolean found = false;
            Operation op = null;
            Iterator i = operationList.iterator();
            while (i.hasNext()) {
                Operation opTemp = (Operation)i.next();
                String name = opTemp.getName();
                if (!name.equals(operationName)) continue;
                if (found) {
                    throw new ProcessorCreationException(procName + ": Operation " + name + " is overloaded in WSDL at " + wsdlLocation);
                }
                op = opTemp;
                found = true;
                Input opInput = op.getInput();
                inputName = opInput.getName() == null ? null : opInput.getName();
                Output opOutput = op.getOutput();
                outputName = opOutput.getName() == null ? null : opOutput.getName();
            }
            if (!found) {
                throw new ProcessorCreationException(procName + ": Unable to locate operation " + operationName + " in WSDL at " + wsdlLocation);
            }
            this.inNames = new String[0];
            this.inTypes = new Class[0];
            Input opInput = op.getInput();
            if (opInput != null) {
                List parts = opInput.getMessage().getOrderedParts(null);
                this.unWrapIfWrappedDocLit(parts, op.getName(), def);
                int count = parts.size();
                this.inNames = new String[count];
                this.inTypes = new Class[count];
                this.retrieveSignature(parts, this.inNames, this.inTypes);
                for (int i2 = 0; i2 < count; ++i2) {
                    InputPort inputPort = new InputPort(this, this.inNames[i2]);
                    inputPort.setSyntacticType(WSDLBasedProcessor.translateJavaType(this.inTypes[i2]));
                    this.addPort(inputPort);
                }
            }
            this.outNames = new String[0];
            this.outTypes = new Class[0];
            Output opOutput = op.getOutput();
            if (opOutput != null) {
                List parts = opOutput.getMessage().getOrderedParts(null);
                this.unWrapIfWrappedDocLit(parts, op.getName() + "Response", def);
                int count = parts.size();
                this.outNames = new String[count];
                this.outTypes = new Class[count];
                this.retrieveSignature(parts, this.outNames, this.outTypes);
                for (int i3 = 0; i3 < count; ++i3) {
                    OutputPort outputPort = new OutputPort(this, this.outNames[i3]);
                    outputPort.setSyntacticType(WSDLBasedProcessor.translateJavaType(this.outTypes[i3]));
                    this.addPort(outputPort);
                }
            }
        }
        catch (DuplicatePortNameException dpne) {
            ProcessorCreationException pce = new ProcessorCreationException("Duplicate port names!");
            pce.initCause(dpne);
            throw pce;
        }
        catch (PortCreationException portce) {
            ProcessorCreationException pce = new ProcessorCreationException("Port creation failure!");
            pce.initCause(portce);
            throw pce;
        }
        catch (ProcessorCreationException pce) {
            throw pce;
        }
        catch (Exception ex) {
            ProcessorCreationException pce = new ProcessorCreationException(procName + ": " + ex.getMessage());
            pce.initCause(ex);
            pce.printStackTrace();
            throw pce;
        }
    }

    WSIFOperation getWSIFOperation() throws WSIFException {
        return this.port.createOperation(this.operationName, this.inputName, this.outputName);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("wsdlLocation", this.getWSDLLocation());
        props.put("operation", this.getOperationName());
        return props;
    }

    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    public String getResourceHost() {
        if (this.port instanceof WSIFPort_ApacheAxis) {
            URL endpoint = ((WSIFPort_ApacheAxis)this.port).getEndPoint();
            return endpoint.getHost();
        }
        return "Unknown";
    }

    String getTargetEndpoint() {
        if (this.port instanceof WSIFPort_ApacheAxis) {
            return ((WSIFPort_ApacheAxis)this.port).getEndPoint().toString();
        }
        return "Unknown";
    }

    public String getOperationName() {
        return this.operationName;
    }

    private void retrieveSignature(List parts, String[] names, Class[] types) {
        for (int i = 0; i < names.length; ++i) {
            Part part = (Part)parts.get(i);
            names[i] = part.getName();
            QName partType = part.getTypeName();
            if (partType == null) {
                partType = part.getElementName();
            }
            if (partType == null) {
                throw new RuntimeException("part " + names[i] + " must have type name declared");
            }
            String s = partType.getLocalPart();
            if ("string".equals(s)) {
                types[i] = class$java$lang$String == null ? WSDLBasedProcessor.class$("java.lang.String") : class$java$lang$String;
                continue;
            }
            if ("arrayof_xsd_string".equalsIgnoreCase(s) || "arrayofstring".equalsIgnoreCase(s)) {
                types[i] = array$Ljava$lang$String == null ? WSDLBasedProcessor.class$("[Ljava.lang.String;") : array$Ljava$lang$String;
                continue;
            }
            if ("double".equals(s)) {
                types[i] = Integer.TYPE;
                continue;
            }
            if ("float".equals(s)) {
                types[i] = Float.TYPE;
                continue;
            }
            if ("int".equals(s)) {
                types[i] = Integer.TYPE;
                continue;
            }
            if ("boolean".equals(s)) {
                types[i] = Boolean.TYPE;
                continue;
            }
            types[i] = class$org$w3c$dom$Element == null ? WSDLBasedProcessor.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element;
            try {
                this.dpf.mapType(partType, class$org$w3c$dom$Element == null ? WSDLBasedProcessor.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                this.dpf.mapType(new QName(partType.getNamespaceURI(), this.getOperationName() + "Response"), class$org$w3c$dom$Element == null ? WSDLBasedProcessor.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                continue;
            }
            catch (WSIFException wsife) {
                wsife.printStackTrace();
            }
        }
    }

    private void unWrapIfWrappedDocLit(List parts, String operationName, Definition def) throws WSIFException {
        Part p = WSIFUtils.getWrappedDocLiteralPart((List)parts, (String)operationName);
        if (p != null) {
            List unWrappedParts = WSIFUtils.unWrapPart((Part)p, (Definition)def);
            parts.remove(p);
            parts.addAll(unWrappedParts);
        }
    }

    private static String translateJavaType(Class type) {
        if (type.equals(String;.class)) {
            return "l('text/plain')";
        }
        if (type.equals(Element.class)) {
            return "'text/xml'";
        }
        return "'text/plain'";
    }
}

