/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.workflow;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.SetOnlineException;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.jdom.Document;
import org.jdom.Element;

public class WorkflowProcessor
extends Processor
implements Serializable {
    private ScuflModel theModel = null;
    private String definitionURL = null;

    public void setOffline() {
        try {
            this.theModel.setOffline(true);
            System.out.println("Set nested processor to offline mode");
        }
        catch (SetOnlineException soe) {
            soe.printStackTrace();
        }
    }

    public void setOnline() {
        try {
            this.theModel.setOffline(false);
            System.out.println("Set nested processor to online mode");
        }
        catch (SetOnlineException soe) {
            soe.printStackTrace();
        }
    }

    public WorkflowProcessor(ScuflModel model, String name, String definitionURL) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        this.definitionURL = definitionURL;
        try {
            this.theModel = new ScuflModel();
            try {
                this.theModel.setOffline(model.isOffline());
            }
            catch (SetOnlineException soe) {
                // empty catch block
            }
            XScuflParser.populate(new URL(definitionURL).openStream(), this.theModel, null);
            this.buildPorts();
            this.createListener();
        }
        catch (MalformedURLException mue) {
            throw new ProcessorCreationException("The supplied definition URL was malformed, specified as '" + definitionURL + "'");
        }
        catch (Exception e) {
            throw new ProcessorCreationException("The workflow processor '" + name + "' caused an exception :\n" + e.getMessage() + "\n during creation. The exception had type :\n" + e.getClass().toString());
        }
    }

    public WorkflowProcessor(ScuflModel model, String name, Element scuflElement) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        try {
            Document doc = new Document((Element)scuflElement.clone());
            this.theModel = new ScuflModel();
            try {
                this.theModel.setOffline(model.isOffline());
            }
            catch (SetOnlineException soe) {
                // empty catch block
            }
            XScuflParser.populate(doc, this.theModel, null);
            this.buildPorts();
            this.createListener();
        }
        catch (Exception e) {
            throw new ProcessorCreationException("The workflow processor '" + name + "' caused an exception :\n" + e.getMessage() + "\n during creation. The exception had type :\n" + e.getClass().toString());
        }
    }

    public WorkflowProcessor(ScuflModel model, String name) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        this.theModel = new ScuflModel();
        this.createListener();
    }

    private void createListener() {
        this.theModel.addListener(new ScuflModelEventListener(){

            public void receiveModelEvent(ScuflModelEvent event) {
                WorkflowProcessor.this.definitionURL = null;
                try {
                    if (!WorkflowProcessor.this.buildPorts()) {
                        WorkflowProcessor.this.fireModelEvent(new ScuflModelEvent(WorkflowProcessor.this, "Underlying workflow changed"));
                    }
                }
                catch (PortCreationException pce) {
                }
                catch (DuplicatePortNameException duplicatePortNameException) {
                    // empty catch block
                }
            }
        });
    }

    private boolean buildPorts() throws PortCreationException, DuplicatePortNameException {
        boolean changed = false;
        Port[] outputs = this.theModel.getWorkflowSinkPorts();
        for (int i = 0; i < outputs.length; ++i) {
            try {
                this.locatePort(outputs[i].getName()).setSyntacticType(outputs[i].getSyntacticType());
                continue;
            }
            catch (UnknownPortException upe) {
                OutputPort newPort = new OutputPort(this, outputs[i].getName());
                newPort.setSyntacticType(outputs[i].getSyntacticType());
                this.addPort(newPort);
                changed = true;
            }
        }
        Port[] inputs = this.theModel.getWorkflowSourcePorts();
        for (int i = 0; i < inputs.length; ++i) {
            try {
                this.locatePort(inputs[i].getName()).setSyntacticType(inputs[i].getSyntacticType());
                continue;
            }
            catch (UnknownPortException upe) {
                InputPort newPort = new InputPort(this, inputs[i].getName());
                newPort.setSyntacticType(inputs[i].getSyntacticType());
                this.addPort(newPort);
                changed = true;
            }
        }
        InputPort[] ourInputPorts = this.getInputPorts();
        for (int i = 0; i < ourInputPorts.length; ++i) {
            String portName = ourInputPorts[i].getName();
            try {
                this.theModel.getWorkflowSourceProcessor().locatePort(portName);
                continue;
            }
            catch (UnknownPortException upe) {
                this.removePort(ourInputPorts[i]);
                changed = true;
            }
        }
        OutputPort[] ourOutputPorts = this.getOutputPorts();
        for (int i = 0; i < ourOutputPorts.length; ++i) {
            String portName = ourOutputPorts[i].getName();
            try {
                this.theModel.getWorkflowSinkProcessor().locatePort(portName);
                continue;
            }
            catch (UnknownPortException upe) {
                this.removePort(ourOutputPorts[i]);
                changed = true;
            }
        }
        return changed;
    }

    public ScuflModel getInternalModel() {
        return this.theModel;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("XScufl URL", this.getDefinitionURL());
        return props;
    }

    public String getDefinitionURL() {
        return this.definitionURL;
    }
}

