/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.talisman;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.talisman.TalismanProcessor;
import org.embl.ebi.escience.talisman.tservice.TeaTray;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class TalismanTask
implements ProcessorTaskWorker {
    private static Logger logger = Logger.getLogger((Class)TalismanTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private Processor proc;

    public TalismanTask(Processor p) {
        this.proc = p;
    }

    public Map execute(Map workflowInputMap, ProcessorTask parentTask) throws TaskExecutionException {
        try {
            TalismanProcessor theProcessor = (TalismanProcessor)this.proc;
            HashMap<String, Object> inputMap = new HashMap<String, Object>();
            Iterator i = workflowInputMap.keySet().iterator();
            while (i.hasNext()) {
                String portName = (String)i.next();
                DataThing theDataThing = (DataThing)workflowInputMap.get(portName);
                inputMap.put(portName, theDataThing.getDataObject());
            }
            Map talismanInputMap = theProcessor.getInputMappings();
            Map talismanOutputMap = theProcessor.getOutputMappings();
            String definitionURL = theProcessor.getTalismanDefinitionURL();
            String triggerName = theProcessor.getTriggerName();
            TeaTray teaTray = new TeaTray();
            URL url = new URL(definitionURL);
            String sessionID = teaTray.createSession(url);
            Iterator i2 = talismanInputMap.keySet().iterator();
            while (i2.hasNext()) {
                String portName = (String)i2.next();
                String talismanName = (String)talismanInputMap.get(portName);
                String portValue = (String)inputMap.get(portName.toLowerCase());
                logger.debug((Object)("Setting value : " + talismanName + " to " + portValue));
                teaTray.setStringValue(sessionID, talismanName, portValue);
            }
            teaTray.invokeTrigger(sessionID, triggerName);
            HashMap<String, DataThing> outMap = new HashMap<String, DataThing>();
            Iterator i3 = talismanOutputMap.keySet().iterator();
            while (i3.hasNext()) {
                String portName = (String)i3.next();
                String talismanName = (String)talismanOutputMap.get(portName);
                String talismanValue = teaTray.getStringValue(sessionID, talismanName);
                logger.debug((Object)("Creating output - portName = " + portName + ", fieldName = " + talismanName));
                outMap.put(portName, new DataThing(talismanValue));
            }
            return outMap;
        }
        catch (Exception ex) {
            logger.error((Object)"Error invoking talisman", (Throwable)ex);
            throw new TaskExecutionException("Task failed due to problem invoking talisman");
        }
    }
}

