/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.talisman;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class TalismanProcessor
extends Processor
implements Serializable {
    private String tscriptURL = null;
    private URL tscriptURLObject = null;
    private Map inputs = null;
    private Map outputs = null;
    private String triggerName = null;
    private String talismanDefinitionURL = null;

    public String getTScriptURL() {
        return this.tscriptURL;
    }

    public URL getTScriptURLObject() {
        return this.tscriptURLObject;
    }

    public Map getInputMappings() {
        return this.inputs;
    }

    public Map getOutputMappings() {
        return this.outputs;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getTalismanDefinitionURL() {
        return this.talismanDefinitionURL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TalismanProcessor(ScuflModel model, String name, String tscript) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        this.tscriptURL = tscript;
        this.inputs = new HashMap();
        this.outputs = new HashMap();
        try {
            URL scriptLocation;
            this.tscriptURLObject = scriptLocation = new URL(tscript);
            SAXBuilder builder = new SAXBuilder(false);
            Document tscriptDocument = builder.build(scriptLocation.openStream());
            Element tscriptElement = tscriptDocument.getRootElement();
            this.triggerName = tscriptElement.getAttributeValue("trigger");
            this.talismanDefinitionURL = tscriptElement.getAttributeValue("url");
            List inputElements = tscriptElement.getChildren("input");
            Iterator i = inputElements.iterator();
            while (i.hasNext()) {
                Element inputElement = (Element)i.next();
                this.inputs.put(inputElement.getAttributeValue("name"), inputElement.getTextTrim());
                try {
                    InputPort newPort = new InputPort(this, inputElement.getAttributeValue("name"));
                    newPort.setSyntacticType("'text/plain'");
                    this.addPort(newPort);
                }
                catch (PortCreationException pce) {
                    throw new ProcessorCreationException("Unable to create port '" + inputElement.getAttributeValue("name") + "' in '" + name + "' : " + pce.getMessage());
                }
                catch (DuplicatePortNameException dpne) {
                    throw new ProcessorCreationException("Duplicate port name '" + inputElement.getAttributeValue("name") + "' in '" + name + "' : " + dpne.getMessage());
                }
            }
            List outputElements = tscriptElement.getChildren("output");
            Iterator i2 = outputElements.iterator();
            while (i2.hasNext()) {
                Element outputElement = (Element)i2.next();
                this.outputs.put(outputElement.getAttributeValue("name"), outputElement.getTextTrim());
                try {
                    OutputPort newPort = new OutputPort(this, outputElement.getAttributeValue("name"));
                    newPort.setSyntacticType("'text/plain'");
                    this.addPort(newPort);
                }
                catch (PortCreationException pce) {
                    throw new ProcessorCreationException("Unable to create port '" + outputElement.getAttributeValue("name") + "' in '" + name + "' : " + pce.getMessage());
                }
                catch (DuplicatePortNameException dpne) {
                    throw new ProcessorCreationException("Duplicate port name '" + outputElement.getAttributeValue("name") + "' in '" + name + "' : " + dpne.getMessage());
                    return;
                }
            }
        }
        catch (JDOMException jde) {
            throw new ProcessorCreationException("Unable to instantiate the TalismanProcessor '" + name + "', error was : " + jde.getMessage());
        }
        catch (MalformedURLException mue) {
            throw new ProcessorCreationException("Unable to read script from '" + tscript + "' for '" + name + "', error was : " + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new ProcessorCreationException("Unable to read script from '" + tscript + "' for '" + name + "', error was : " + ioe.getMessage());
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("TScript URL", this.getTScriptURL());
        return props;
    }
}

