/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.soaplab;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabProcessor;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class SoaplabTask
implements ProcessorTaskWorker {
    private static Logger logger = Logger.getLogger((Class)SoaplabTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private Processor proc;

    public SoaplabTask(Processor p) {
        this.proc = p;
    }

    public Map execute(Map inputMap, ProcessorTask parentTask) throws TaskExecutionException {
        try {
            HashMap<String, DataThing> outMap = null;
            HashMap<String, Object> soaplabInputMap = new HashMap<String, Object>();
            Iterator i = inputMap.keySet().iterator();
            while (i.hasNext()) {
                String parameterName = (String)i.next();
                Object parameterValue = ((DataThing)inputMap.get(parameterName)).getDataObject();
                soaplabInputMap.put(parameterName, parameterValue);
            }
            Call call = (Call)new Service().createCall();
            call.setTimeout(new Integer(0));
            URL soaplabWSDLURL = ((SoaplabProcessor)this.proc).getEndpoint();
            String soaplabWSDL = soaplabWSDLURL.toExternalForm();
            call.setTargetEndpointAddress(soaplabWSDLURL);
            call.setOperationName(new QName("createAndRun"));
            String jobID = (String)call.invoke(new Object[]{soaplabInputMap});
            OutputPort[] boundOutputs = this.proc.getBoundOutputPorts();
            String[] outputPortNames = new String[boundOutputs.length];
            for (int i2 = 0; i2 < outputPortNames.length; ++i2) {
                outputPortNames[i2] = boundOutputs[i2].getName();
                System.out.println("Adding output : " + outputPortNames[i2]);
            }
            call.setOperationName(new QName("waitFor"));
            call.invoke(new Object[]{jobID});
            call.setOperationName(new QName("getSomeResults"));
            HashMap outputMap = new HashMap((Map)call.invoke(new Object[]{jobID, outputPortNames}));
            call.setOperationName(new QName("destroy"));
            call.invoke(new Object[]{jobID});
            outMap = new HashMap<String, DataThing>();
            Iterator i3 = outputMap.keySet().iterator();
            while (i3.hasNext()) {
                String parameterName = (String)i3.next();
                Object outputObject = outputMap.get(parameterName);
                DataThing outputThing = null;
                logger.debug((Object)("Soaplab : parameter '" + parameterName + "' has type '" + outputObject.getClass().getName() + "'"));
                outputThing = outputObject instanceof String[] ? DataThingFactory.bake((String[])outputObject) : (outputObject instanceof byte[][] ? DataThingFactory.bake((byte[][])outputObject) : (outputObject instanceof List ? DataThingFactory.bakeForSoaplab((List)outputObject) : new DataThing(outputObject)));
                outMap.put(parameterName, outputThing);
            }
            return outMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Error invoking soaplab service for soaplab", (Throwable)ex);
            TaskExecutionException tee = new TaskExecutionException("Task failed due to problem invoking soaplab service");
            tee.initCause(ex);
            throw tee;
        }
    }
}

