/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.seqhound;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.blueprint.seqhound.SeqHound;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflworkers.seqhound.SeqHoundForTaverna;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SeqhoundProcessor
extends Processor {
    private String methodName;
    private String server;
    private String path;
    private String jseqremServer;
    private String jseqremPath;
    Map inputTypes = new HashMap();
    SeqHoundForTaverna seqhound;
    Method targetMethod;
    Properties config = new Properties();
    static Map descriptions;
    static Map parameters;

    public SeqhoundProcessor(ScuflModel theModel, String processorName, String methodName, String server, String path, String jseqremServer, String jseqremPath) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(theModel, processorName);
        this.methodName = methodName;
        this.server = server;
        this.path = path;
        this.jseqremServer = jseqremServer;
        this.jseqremPath = jseqremPath;
        this.config.setProperty("server", server);
        this.config.setProperty("jseqremserver", jseqremServer);
        this.config.setProperty("cgi", path);
        this.config.setProperty("jseqremcgi", jseqremPath);
        this.seqhound = new SeqHoundForTaverna(this.config);
        try {
            this.seqhound.SHoundInit(true, "Taverna");
        }
        catch (IOException ioe) {
            throw new ProcessorCreationException("Unable to contact the seqhound server!");
        }
        String description = (String)descriptions.get(methodName);
        if (description != null) {
            this.setDescription(description);
        }
        Class theClass = SeqHound.class;
        Method[] methods = theClass.getDeclaredMethods();
        Method theMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            theMethod = methods[i];
            break;
        }
        if (theMethod == null) {
            throw new ProcessorCreationException("Unable to locate method '" + methodName + "' in SeqHound API");
        }
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        Class<?> returnType = theMethod.getReturnType();
        this.targetMethod = theMethod;
        String[] parameterNames = (String[])parameters.get(methodName);
        try {
            for (int i = 0; i < parameterTypes.length; ++i) {
                InputPort ip = parameterNames == null ? new InputPort(this, "in" + i) : new InputPort(this, parameterNames[i]);
                if (parameterTypes[i].isArray()) {
                    ip.setSyntacticType("l('text/plain')");
                } else {
                    ip.setSyntacticType("'text/plain'");
                }
                this.inputTypes.put(ip.getName(), parameterTypes[i]);
                this.addPort(ip);
            }
            if (returnType.isArray()) {
                OutputPort op = new OutputPort(this, "result");
                op.setSyntacticType("l('text/plain')");
                this.addPort(op);
            } else if (returnType.equals(Hashtable.class)) {
                OutputPort op1 = new OutputPort(this, "keys");
                op1.setSyntacticType("l('text/plain')");
                this.addPort(op1);
                OutputPort op2 = new OutputPort(this, "values");
                op2.setSyntacticType("l('text/plain')");
                this.addPort(op2);
            } else {
                OutputPort op = new OutputPort(this, "result");
                op.setSyntacticType("'text/plain'");
                this.addPort(op);
            }
        }
        catch (DuplicatePortNameException dpne) {
        }
        catch (PortCreationException pce) {
            // empty catch block
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public String getJseqremServer() {
        return this.jseqremServer;
    }

    public String getJseqremPath() {
        return this.jseqremPath;
    }

    public Properties getProperties() {
        return this.config;
    }

    public String getResourceHost() {
        return this.server;
    }

    static {
        URL serviceMetadata;
        descriptions = new HashMap();
        parameters = new HashMap();
        ClassLoader loader = SeqhoundProcessor.class.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((serviceMetadata = loader.getResource("org/embl/ebi/escience/scuflworkers/seqhound/services.xml")) != null) {
            Document document = null;
            try {
                InputStream is = serviceMetadata.openStream();
                InputStreamReader isr = new InputStreamReader(is);
                SAXBuilder builder = new SAXBuilder(false);
                document = builder.build((Reader)isr);
                List services = document.getRootElement().getChildren("service");
                Iterator i = services.iterator();
                while (i.hasNext()) {
                    Element service = (Element)i.next();
                    String serviceName = service.getAttributeValue("name");
                    String serviceDescription = service.getChild("description").getTextTrim();
                    descriptions.put(serviceName, serviceDescription);
                    List parameterElements = service.getChild("parameters").getChildren("parameter");
                    String[] parameterNames = new String[parameterElements.size()];
                    for (int j = 0; j < parameterNames.length; ++j) {
                        Element parameterElement = (Element)parameterElements.get(j);
                        parameterNames[j] = parameterElement.getAttributeValue("name");
                    }
                    parameters.put(serviceName, parameterNames);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("No seqhound service metadata available");
        }
    }
}

