/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.java;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scuflui.workbench.Scavenger;
import org.embl.ebi.escience.scuflui.workbench.ScavengerCreationException;
import org.embl.ebi.escience.scuflworkers.java.LocalServiceProcessorFactory;

public class LocalServiceScavenger
extends Scavenger {
    private static Logger LOG = Logger.getLogger((Class)LocalServiceScavenger.class);
    private static Map workerList = new HashMap();

    public LocalServiceScavenger() throws ScavengerCreationException {
        super("Local Java widgets");
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();
        Iterator<Object> i = workerList.keySet().iterator();
        while (i.hasNext()) {
            DefaultMutableTreeNode categoryNode;
            String key = (String)i.next();
            Scavenger s = (Scavenger)workerList.get(key);
            String category = "default";
            if (key.split(":").length == 2) {
                category = key.split(":")[0];
            }
            if (nodeMap.containsKey(category)) {
                categoryNode = (DefaultMutableTreeNode)nodeMap.get(category);
            } else {
                categoryNode = new DefaultMutableTreeNode(category);
                nodeMap.put(category, categoryNode);
            }
            categoryNode.add(s);
        }
        i = nodeMap.values().iterator();
        while (i.hasNext()) {
            this.add((DefaultMutableTreeNode)i.next());
        }
    }

    static {
        try {
            LOG.warn((Object)"Loading LocalWorker implementations");
            Enumeration<URL> en = LocalServiceScavenger.class.getClassLoader().getResources("META-INF/services/org.embl.ebi.escience.scuflworkers.java.LocalWorker");
            Properties tavernaProperties = new Properties();
            while (en.hasMoreElements()) {
                URL resourceURL = en.nextElement();
                LOG.debug((Object)("Loading workers from: " + resourceURL));
                tavernaProperties.load(resourceURL.openStream());
            }
            Iterator<Object> i = tavernaProperties.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                String description = (String)tavernaProperties.get(className);
                String[] split = description.split(":");
                String category = "default";
                if (split.length == 2) {
                    category = split[0];
                    description = split[1];
                }
                LOG.debug((Object)("Worker: " + className + " category: " + category + " desc: " + description));
                workerList.put((String)tavernaProperties.get(className), new Scavenger(new LocalServiceProcessorFactory(className, description)));
            }
            LOG.warn((Object)("Loaded: " + workerList));
        }
        catch (Exception e) {
            LOG.error((Object)"Failure in initialization of LocalWorker scavenger", (Throwable)e);
        }
    }
}

