/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.java;

import java.util.Properties;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scuflworkers.java.LocalWorker;

public class LocalServiceProcessor
extends Processor {
    private String workerClassName;
    private LocalWorker theImplementation;

    public String getWorkerClassName() {
        return this.workerClassName;
    }

    protected LocalWorker getWorker() {
        return this.theImplementation;
    }

    public LocalServiceProcessor(ScuflModel model, String name, String workerClassName) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        this.workerClassName = workerClassName;
        try {
            Port p;
            int i;
            Class<?> theClass = Class.forName(workerClassName);
            this.theImplementation = (LocalWorker)theClass.newInstance();
            for (i = 0; i < this.theImplementation.inputNames().length; ++i) {
                p = new InputPort(this, this.theImplementation.inputNames()[i]);
                p.setSyntacticType(this.theImplementation.inputTypes()[i]);
                this.addPort(p);
            }
            for (i = 0; i < this.theImplementation.outputNames().length; ++i) {
                p = new OutputPort(this, this.theImplementation.outputNames()[i]);
                p.setSyntacticType(this.theImplementation.outputTypes()[i]);
                SemanticMarkup m = p.getMetadata();
                String[] mimeTypes = this.theImplementation.outputTypes()[i].split("\\'")[1].split(",");
                for (int j = 0; j < mimeTypes.length; ++j) {
                    System.out.println(mimeTypes[j]);
                    m.addMIMEType(mimeTypes[j]);
                }
                this.addPort(p);
            }
        }
        catch (DuplicatePortNameException dpne) {
            throw new ProcessorCreationException("The supplied specification for the local service processor '" + name + "' contained a duplicate port '" + dpne.getMessage() + "'");
        }
        catch (PortCreationException pce) {
            throw new ProcessorCreationException("An error occured whilst generating ports for the local service processor " + pce.getMessage());
        }
        catch (Exception e) {
            ProcessorCreationException pce = new ProcessorCreationException("Unable to instantiate processor for local service class " + workerClassName);
            pce.initCause(e);
            throw pce;
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("WorkerClass", this.workerClassName);
        return props;
    }
}

