/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.biomoby;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.biomoby.client.CentralImpl;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyService;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;

public class BiomobyProcessor
extends Processor
implements Serializable {
    private URL endpoint;
    private String mobyEndpoint = null;
    private Central worker = null;
    private MobyService mobyService = null;
    private String serviceName = null;
    private String authorityName = null;

    public BiomobyProcessor(ScuflModel model, String processorName, String authorityName, String serviceName, String mobyEndpoint) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, processorName);
        this.mobyEndpoint = mobyEndpoint;
        this.serviceName = serviceName;
        this.authorityName = authorityName;
        if (!this.isOffline()) {
            this.init();
        } else {
            try {
                this.endpoint = new URL("http://unknown.host.org/UnknownHost");
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
    }

    public BiomobyProcessor(ScuflModel model, String processorName, MobyService service, String mobyEndpoint) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, processorName);
        this.mobyEndpoint = mobyEndpoint;
        this.serviceName = service.getName();
        this.authorityName = service.getAuthority();
        this.mobyService = service;
        if (!this.isOffline()) {
            this.init();
        } else {
            try {
                this.endpoint = new URL(service.getURL());
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
    }

    void init() throws ProcessorCreationException {
        try {
            String serviceEndpoint;
            if (this.mobyService == null) {
                this.worker = new CentralImpl(this.mobyEndpoint);
                MobyService pattern = new MobyService(this.serviceName);
                pattern.setAuthority(this.authorityName);
                MobyService[] services = this.worker.findService(pattern);
                if (services == null || services.length == 0) {
                    throw new ProcessorCreationException(this.formatError("I cannot find the service."));
                }
                this.mobyService = services[0];
            }
            if ((serviceEndpoint = this.mobyService.getURL()) == null || serviceEndpoint.equals("")) {
                throw new ProcessorCreationException(this.formatError("Service has an empty endpoint."));
            }
            try {
                this.setEndpoint(serviceEndpoint);
            }
            catch (MalformedURLException e2) {
                throw new ProcessorCreationException(this.formatError("Service has malformed endpoint: '" + serviceEndpoint + "'."));
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessorCreationException) {
                throw (ProcessorCreationException)e;
            }
            throw new ProcessorCreationException(this.formatError(e.toString()));
        }
    }

    public String getResourceHost() {
        return this.authorityName;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("Biomoby service URL", this.getEndpoint().toString());
        return props;
    }

    public String getMobyEndpoint() {
        return this.mobyEndpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setEndpoint(String specifier) throws MalformedURLException, ProcessorCreationException {
        URL new_endpoint = new URL(specifier);
        if (this.endpoint != null) {
            if (this.endpoint.equals(new_endpoint)) return;
            this.fireModelEvent(new ScuflModelEvent(this, "Service endpoint changed to '" + specifier + "'"));
        } else {
            this.fireModelEvent(new ScuflModelEvent(this, "Service endpoint set to '" + specifier + "'"));
        }
        this.endpoint = new_endpoint;
        try {
            this.generatePorts();
            this.getDescriptionText();
            return;
        }
        catch (PortCreationException e) {
            throw new ProcessorCreationException(this.formatError("When trying to create ports: " + e.getMessage()));
        }
        catch (DuplicatePortNameException e) {
            throw new ProcessorCreationException(this.formatError("When trying to create ports: " + e.getMessage()));
        }
    }

    public void getDescriptionText() throws ProcessorCreationException {
        if (this.mobyService.getDescription() != null) {
            this.setDescription(this.mobyService.getDescription());
        }
    }

    public void generatePorts() throws ProcessorCreationException, PortCreationException, DuplicatePortNameException {
        this.ports = new ArrayList();
        InputPort input_port = new InputPort(this, "input");
        boolean isInputCollection = false;
        MobyData[] inputs = this.mobyService.getPrimaryInputs();
        for (int i = 0; i < inputs.length; ++i) {
            if (!(inputs[i] instanceof MobyPrimaryDataSet)) continue;
            isInputCollection = true;
            break;
        }
        input_port.setSyntacticType(isInputCollection ? "l('text/xml')" : "'text/xml'");
        this.addPort(input_port);
        OutputPort output_port = new OutputPort(this, "output");
        boolean isOutputCollection = false;
        MobyData[] outputs = this.mobyService.getPrimaryOutputs();
        for (int i = 0; i < outputs.length; ++i) {
            if (!(outputs[i] instanceof MobyPrimaryDataSet)) continue;
            isOutputCollection = true;
            break;
        }
        output_port.setSyntacticType(isOutputCollection ? "l('text/xml')" : "'text/xml'");
        this.addPort(output_port);
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    protected String formatError(String msg) {
        return "Problems with service '" + this.serviceName + "' provided by authority '" + this.authorityName + "'\nfrom Moby registry at " + this.mobyEndpoint + ":\n\n" + msg;
    }
}

