/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.beanshell;

import java.util.Iterator;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.XScufl;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.embl.ebi.escience.scuflworkers.beanshell.BeanshellProcessor;
import org.embl.ebi.escience.scuflworkers.beanshell.BeanshellProcessorFactory;
import org.jdom.Content;
import org.jdom.Element;

public class BeanshellXMLHandler
implements XMLHandler {
    public Element elementForProcessor(Processor p) {
        BeanshellProcessor bp = (BeanshellProcessor)p;
        Element spec = new Element("beanshell", XScufl.XScuflNS);
        Element script = new Element("scriptvalue", XScufl.XScuflNS);
        script.setText(bp.getScript());
        spec.addContent((Content)script);
        Element inputList = new Element("beanshellinputlist", XScufl.XScuflNS);
        InputPort[] inputs = bp.getInputPorts();
        for (int i = 0; i < inputs.length; ++i) {
            Element inputElement = new Element("beanshellinput", XScufl.XScuflNS);
            inputElement.setText(inputs[i].getName());
            if (inputs[i].getSyntacticType() != null) {
                inputElement.setAttribute("syntactictype", inputs[i].getSyntacticType(), XScufl.XScuflNS);
            }
            inputList.addContent((Content)inputElement);
        }
        spec.addContent((Content)inputList);
        Element outputList = new Element("beanshelloutputlist", XScufl.XScuflNS);
        OutputPort[] outputs = bp.getOutputPorts();
        for (int i = 0; i < outputs.length; ++i) {
            Element outputElement = new Element("beanshelloutput", XScufl.XScuflNS);
            outputElement.setText(outputs[i].getName());
            if (outputs[i].getSyntacticType() != null) {
                outputElement.setAttribute("syntactictype", outputs[i].getSyntacticType(), XScufl.XScuflNS);
            }
            outputList.addContent((Content)outputElement);
        }
        spec.addContent((Content)outputList);
        return spec;
    }

    public Element elementForFactory(ProcessorFactory pf) {
        return new Element("beanshell", XScufl.XScuflNS);
    }

    public ProcessorFactory getFactory(Element specElement) {
        return new BeanshellProcessorFactory();
    }

    public Processor loadProcessorFromXML(Element processorNode, ScuflModel model, String name) throws ProcessorCreationException, DuplicateProcessorNameException, XScuflFormatException {
        Element outputList;
        Element inputList;
        BeanshellProcessor bp = new BeanshellProcessor(model, name, "", new String[0], new String[0]);
        Element beanshell = processorNode.getChild("beanshell", XScufl.XScuflNS);
        Element scriptElement = beanshell.getChild("scriptvalue", XScufl.XScuflNS);
        if (scriptElement != null) {
            String script = scriptElement.getTextTrim();
            bp.setScript(script);
        }
        if ((inputList = beanshell.getChild("beanshellinputlist", XScufl.XScuflNS)) != null) {
            Iterator i = inputList.getChildren().iterator();
            while (i.hasNext()) {
                Element inputElement = (Element)i.next();
                String inputName = inputElement.getTextTrim();
                String syntacticType = inputElement.getAttributeValue("syntactictype", XScufl.XScuflNS);
                try {
                    InputPort p = new InputPort(bp, inputName);
                    if (syntacticType != null) {
                        p.setSyntacticType(syntacticType);
                    }
                    bp.addPort(p);
                }
                catch (PortCreationException pce) {
                    throw new ProcessorCreationException("Unable to create port! " + pce.getMessage());
                }
                catch (DuplicatePortNameException dpne) {
                    throw new ProcessorCreationException("Unable to create port! " + dpne.getMessage());
                }
            }
        }
        if ((outputList = beanshell.getChild("beanshelloutputlist", XScufl.XScuflNS)) != null) {
            Iterator i = outputList.getChildren().iterator();
            while (i.hasNext()) {
                Element outputElement = (Element)i.next();
                String outputName = outputElement.getTextTrim();
                String syntacticType = outputElement.getAttributeValue("syntactictype", XScufl.XScuflNS);
                try {
                    OutputPort p = new OutputPort(bp, outputName);
                    if (syntacticType != null) {
                        p.setSyntacticType(syntacticType);
                    }
                    bp.addPort(p);
                }
                catch (PortCreationException pce) {
                    throw new ProcessorCreationException("Unable to create port! " + pce.getMessage());
                }
                catch (DuplicatePortNameException dpne) {
                    throw new ProcessorCreationException("Unable to create port! " + dpne.getMessage());
                }
            }
        }
        return bp;
    }
}

