/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.beanshell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflworkers.beanshell.BeanshellConfigPanel;
import org.embl.ebi.escience.scuflworkers.beanshell.BeanshellProcessor;

public class BeanshellConfigPanel
extends JPanel
implements ScuflUIComponent {
    private BeanshellProcessor processor = null;

    public BeanshellConfigPanel(BeanshellProcessor bp) {
        super(new BorderLayout());
        this.setLayout(new BoxLayout(this, 3));
        this.processor = bp;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.add(tabbedPane);
        JPanel scriptEditPanel = new JPanel(new BorderLayout());
        scriptEditPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Beanshell Script"));
        final JTextArea scriptText = new JTextArea();
        JScrollPane scriptPane = new JScrollPane(scriptText);
        scriptText.setText(this.processor.getScript());
        scriptEditPanel.add((Component)scriptPane, "Center");
        JButton scriptUpdateButton = new JButton("Update");
        scriptUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BeanshellConfigPanel.this.processor.setScript(scriptText.getText());
            }
        });
        scriptEditPanel.add((Component)scriptUpdateButton, "South");
        tabbedPane.addTab("Script", scriptEditPanel);
        JPanel portEditPanel = new JPanel(new GridLayout(0, 2));
        final DefaultListModel inputModel = new DefaultListModel();
        this.updateInputListModel(inputModel);
        final DefaultListModel outputModel = new DefaultListModel();
        this.updateOutputListModel(outputModel);
        JPanel inputEditPanel = new JPanel(new BorderLayout());
        inputEditPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inputs"));
        JList<Object> inputList = new JList<Object>(inputModel);
        inputList.setPrototypeCellValue("aaaaaaaaaaaaaaaaaaa");
        inputList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                this.setIcon(ScuflIcons.inputPortIcon);
                return this;
            }
        });
        inputList.setSelectionMode(0);
        new PortListMouseListener(inputList, inputModel, true);
        JScrollPane inputPane = new JScrollPane(inputList);
        inputEditPanel.add((Component)inputPane, "Center");
        final JTextField addInputField = new JTextField();
        addInputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    InputPort ip = new InputPort(BeanshellConfigPanel.this.processor, addInputField.getText());
                    ip.setSyntacticType("'text/plain'");
                    BeanshellConfigPanel.this.processor.addPort(ip);
                    BeanshellConfigPanel.this.updateInputListModel(inputModel);
                }
                catch (PortCreationException pce) {
                }
                catch (DuplicatePortNameException duplicatePortNameException) {
                    // empty catch block
                }
            }
        });
        inputEditPanel.add((Component)addInputField, "South");
        portEditPanel.add(inputEditPanel);
        JPanel outputEditPanel = new JPanel(new BorderLayout());
        outputEditPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Outputs"));
        JList<Object> outputList = new JList<Object>(outputModel);
        outputList.setPrototypeCellValue("aaaaaaaaaaaaaaaaaaa");
        outputList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                this.setIcon(ScuflIcons.outputPortIcon);
                return this;
            }
        });
        outputList.setSelectionMode(0);
        new PortListMouseListener(outputList, outputModel, false);
        JScrollPane outputPane = new JScrollPane(outputList);
        outputEditPanel.add((Component)outputPane, "Center");
        final JTextField addOutputField = new JTextField();
        addOutputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    OutputPort op = new OutputPort(BeanshellConfigPanel.this.processor, addOutputField.getText());
                    op.setSyntacticType("'text/plain'");
                    BeanshellConfigPanel.this.processor.addPort(op);
                    BeanshellConfigPanel.this.updateOutputListModel(outputModel);
                }
                catch (PortCreationException pce) {
                }
                catch (DuplicatePortNameException duplicatePortNameException) {
                    // empty catch block
                }
                BeanshellConfigPanel.this.updateInputListModel(inputModel);
            }
        });
        outputEditPanel.add((Component)addOutputField, "South");
        portEditPanel.add(outputEditPanel);
        tabbedPane.addTab("Ports", portEditPanel);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputListModel(DefaultListModel model) {
        DefaultListModel defaultListModel = model;
        synchronized (defaultListModel) {
            model.clear();
            InputPort[] ports = this.processor.getInputPorts();
            for (int i = 0; i < ports.length; ++i) {
                model.addElement(ports[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutputListModel(DefaultListModel model) {
        DefaultListModel defaultListModel = model;
        synchronized (defaultListModel) {
            model.clear();
            OutputPort[] ports = this.processor.getOutputPorts();
            for (int i = 0; i < ports.length; ++i) {
                model.addElement(ports[i]);
            }
        }
    }

    public void attachToModel(ScuflModel theModel) {
    }

    public void detachFromModel() {
    }

    public String getName() {
        return "Configuring beanshell for " + this.processor.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    protected class PortListMouseListener
    extends MouseAdapter {
        protected JList list;
        protected DefaultListModel listModel;
        protected boolean inputFlag;

        PortListMouseListener(JList list, DefaultListModel listModel, boolean inputFlag) {
            this.list = list;
            this.listModel = listModel;
            this.inputFlag = inputFlag;
            list.addMouseListener(this);
        }

        public void mousePressed(MouseEvent me) {
            this.popup(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.popup(me);
        }

        protected void popup(MouseEvent me) {
            if (me.isPopupTrigger()) {
                int index = this.list.locationToIndex(new Point(me.getX(), me.getY()));
                if (index < 0 || index >= this.list.getModel().getSize()) {
                    return;
                }
                this.list.setSelectedIndex(index);
                Port p = (Port)this.list.getModel().getElementAt(index);
                if (p != null) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new JMenuItem(new AbstractAction(this, "Remove port", p){
                        private final /* synthetic */ Port val$p;
                        private final /* synthetic */ PortListMouseListener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$p = val$p;
                            super(x0);
                        }

                        public void actionPerformed(ActionEvent ae) {
                            BeanshellConfigPanel.access$000(PortListMouseListener.access$300(this.this$1)).removePort(this.val$p);
                            if (this.this$1.inputFlag) {
                                BeanshellConfigPanel.access$100(PortListMouseListener.access$300(this.this$1), this.this$1.listModel);
                            } else {
                                BeanshellConfigPanel.access$200(PortListMouseListener.access$300(this.this$1), this.this$1.listModel);
                            }
                        }
                    }));
                    menu.add(new JMenuItem(new AbstractAction(this, "Edit syntactic type", p){
                        private final /* synthetic */ Port val$p;
                        private final /* synthetic */ PortListMouseListener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$p = val$p;
                            super(x0);
                        }

                        public void actionPerformed(ActionEvent ae) {
                            JTextField field = new JTextField(40);
                            if (this.val$p.getSyntacticType() != null) {
                                field.setText(this.val$p.getSyntacticType());
                            }
                            JDialog dialog = new JDialog();
                            dialog.setDefaultCloseOperation(2);
                            dialog.setTitle("Edit syntactic type of " + this.val$p.getName());
                            dialog.getContentPane().setLayout(new BorderLayout());
                            dialog.getContentPane().add(field);
                            field.addActionListener(new ActionListener(this, field, dialog){
                                private final /* synthetic */ JTextField val$field;
                                private final /* synthetic */ JDialog val$dialog;
                                private final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$field = val$field;
                                    this.val$dialog = val$dialog;
                                }

                                public void actionPerformed(ActionEvent ae) {
                                    7.access$400(this.this$2).setSyntacticType(this.val$field.getText());
                                    this.val$dialog.dispose();
                                }
                            });
                            dialog.pack();
                            dialog.setVisible(true);
                        }

                        static /* synthetic */ Port access$400(7 x0) {
                            return x0.val$p;
                        }
                    }));
                    menu.show(this.list, me.getX(), me.getY());
                }
            }
        }

        static /* synthetic */ BeanshellConfigPanel access$300(PortListMouseListener x0) {
            return x0.BeanshellConfigPanel.this;
        }
    }
}

