/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.AnnotationTemplate;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.XScufl;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scuflui.workbench.Scavenger;
import org.embl.ebi.escience.scuflworkers.ProcessorEditor;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.ScavengerHelper;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.jdom.Element;

public class ProcessorHelper {
    private static Logger LOG = Logger.getLogger((Class)ProcessorHelper.class);
    static Map coloursForTagName = new HashMap();
    static Map tagNameForClassName = new HashMap();
    static Map classNameForTagName = new HashMap();
    static Map iconForTagName = null;
    static Map taskClassForTagName = new HashMap();
    static Map xmlHandlerForTagName = new HashMap();
    static Map tagNameForScavenger = new HashMap();
    static Map editorForTagName = new HashMap();
    static Set simpleScavengers = new HashSet();
    static Properties tavernaProperties = null;
    static ImageIcon unknownProcessorIcon;

    public static Set getSimpleScavengerSet() {
        return simpleScavengers;
    }

    public static Map getScavengerToTagNames() {
        return tagNameForScavenger;
    }

    public static String getTaskClassName(Processor p) {
        String taskClassName;
        String className = p.getClass().getName();
        String tagName = (String)tagNameForClassName.get(className);
        if (tagName != null && (taskClassName = (String)taskClassForTagName.get(tagName)) != null) {
            return taskClassName;
        }
        return null;
    }

    public static ProcessorTaskWorker getTaskWorker(Processor p) {
        String taskClassName = ProcessorHelper.getTaskClassName(p);
        if (taskClassName != null) {
            try {
                Class[] constructorClasses = new Class[]{Processor.class};
                Class<?> taskClass = Class.forName(taskClassName);
                Constructor<?> taskConstructor = taskClass.getConstructor(constructorClasses);
                ProcessorTaskWorker taskWorker = (ProcessorTaskWorker)taskConstructor.newInstance(p);
                return taskWorker;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static String getTagNameForClassName(String className) {
        return (String)tagNameForClassName.get(className);
    }

    public static ProcessorEditor getEditorForTagName(String tagName) {
        return (ProcessorEditor)editorForTagName.get(tagName);
    }

    public static XMLHandler getXMLHandlerForTagName(String tagname) {
        return (XMLHandler)xmlHandlerForTagName.get(tagname);
    }

    public static ImageIcon getIconForTagName(String tagName) {
        ImageIcon icon;
        if (iconForTagName == null) {
            iconForTagName = new HashMap();
            Iterator<Object> i = tavernaProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = tavernaProperties.getProperty(key);
                String[] keyElements = key.split("\\.");
                if (keyElements.length != 4 || !keyElements[1].equals("processor")) continue;
                String loadTagName = keyElements[2];
                if (!keyElements[3].equals("icon")) continue;
                iconForTagName.put(loadTagName, new ImageIcon((class$org$embl$ebi$escience$scuflworkers$ProcessorHelper == null ? ProcessorHelper.class$("org.embl.ebi.escience.scuflworkers.ProcessorHelper") : class$org$embl$ebi$escience$scuflworkers$ProcessorHelper).getClassLoader().getResource(value)));
            }
        }
        if ((icon = (ImageIcon)iconForTagName.get(tagName)) == null) {
            return unknownProcessorIcon;
        }
        return icon;
    }

    public static String getPreferredColour(Processor p) {
        String colour;
        String className = p.getClass().getName();
        String tagName = (String)tagNameForClassName.get(className);
        if (tagName != null && (colour = (String)coloursForTagName.get(tagName)) != null) {
            return colour;
        }
        return "white";
    }

    public static ImageIcon getPreferredIcon(Processor p) {
        ImageIcon icon;
        String className = p.getClass().getName();
        String tagName = (String)tagNameForClassName.get(className);
        if (tagName != null && (icon = (ImageIcon)iconForTagName.get(tagName)) != null) {
            return icon;
        }
        return unknownProcessorIcon;
    }

    public static Element elementForProcessor(Processor p) {
        XMLHandler xh;
        String className = p.getClass().getName();
        String tagName = (String)tagNameForClassName.get(className);
        if (tagName != null && (xh = (XMLHandler)xmlHandlerForTagName.get(tagName)) != null) {
            Element result = xh.elementForProcessor(p);
            if (p.getRetries() != 0) {
                result.setAttribute("maxretries", Integer.toString(p.getRetries()));
            }
            if (p.getRetryDelay() != 0) {
                result.setAttribute("retrydelay", Integer.toString(p.getRetryDelay()));
            }
            if (p.getBackoff() != 1.0) {
                result.setAttribute("retrybackoff", Double.toString(p.getBackoff()));
            }
            if (p.getCritical()) {
                result.setAttribute("critical", "" + p.getCritical());
            }
            return result;
        }
        return null;
    }

    public static ProcessorFactory loadFactoryFromXML(Element specNode) {
        String tagName = specNode.getName();
        XMLHandler xh = (XMLHandler)xmlHandlerForTagName.get(tagName);
        if (xh == null) {
            return null;
        }
        return xh.getFactory(specNode);
    }

    public static Processor loadProcessorFromXML(Element processorNode, ScuflModel model, String name) throws ProcessorCreationException, DuplicateProcessorNameException, XScuflFormatException {
        Iterator i;
        List l;
        LOG.debug((Object)("Attempting to load processor for: " + processorNode));
        Processor loadedProcessor = null;
        Iterator i2 = processorNode.getChildren().iterator();
        while (i2.hasNext() && loadedProcessor == null) {
            String critical;
            String retryBackoffString;
            String retryDelayString;
            Element candidateElement = (Element)i2.next();
            String elementName = candidateElement.getName();
            XMLHandler xh = (XMLHandler)xmlHandlerForTagName.get(elementName);
            LOG.debug((Object)("Possible help: " + candidateElement + " " + elementName + " -> " + xh));
            if (xh == null) continue;
            loadedProcessor = xh.loadProcessorFromXML(processorNode, model, name);
            String maxRetryString = candidateElement.getAttributeValue("maxretries");
            if (maxRetryString != null) {
                loadedProcessor.setRetries(Integer.parseInt(maxRetryString));
            }
            if ((retryDelayString = candidateElement.getAttributeValue("retrydelay")) != null) {
                loadedProcessor.setRetryDelay(Integer.parseInt(retryDelayString));
            }
            if ((retryBackoffString = candidateElement.getAttributeValue("retrybackoff")) != null) {
                loadedProcessor.setBackoff(Double.parseDouble(retryBackoffString));
            }
            if ((critical = candidateElement.getAttributeValue("critical")) == null) continue;
            loadedProcessor.setCritical(new Boolean(critical));
        }
        int alternateCount = 1;
        if (loadedProcessor != null) {
            l = processorNode.getChildren("alternate", XScufl.XScuflNS);
            i = l.iterator();
            while (i.hasNext()) {
                Element alternateElement = (Element)i.next();
                Processor alternateProcessor = ProcessorHelper.loadProcessorFromXML(alternateElement, null, "alternate" + alternateCount++);
                AlternateProcessor ap = new AlternateProcessor(alternateProcessor);
                List inputMapping = alternateElement.getChildren("inputmap", XScufl.XScuflNS);
                Iterator j = inputMapping.iterator();
                while (j.hasNext()) {
                    Element inputMapItem = (Element)j.next();
                    String key = inputMapItem.getAttributeValue("key");
                    String value = inputMapItem.getAttributeValue("value");
                    ap.getInputMapping().put(key, value);
                }
                List outputMapping = alternateElement.getChildren("outputmap", XScufl.XScuflNS);
                Iterator j2 = outputMapping.iterator();
                while (j2.hasNext()) {
                    Element outputMapItem = (Element)j2.next();
                    String key = outputMapItem.getAttributeValue("key");
                    String value = outputMapItem.getAttributeValue("value");
                    ap.getOutputMapping().put(key, value);
                }
                loadedProcessor.addAlternate(ap);
            }
        }
        if (loadedProcessor != null) {
            l = processorNode.getChildren("template", XScufl.XScuflNS);
            i = l.iterator();
            while (i.hasNext()) {
                loadedProcessor.addAnnotationTemplate(new AnnotationTemplate((Element)i.next()));
            }
        }
        if (loadedProcessor == null) {
            LOG.warn((Object)("No processor found for element: " + processorNode));
        }
        return loadedProcessor;
    }

    static {
        try {
            ClassLoader loader = ProcessorHelper.class.getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            unknownProcessorIcon = new ImageIcon(loader.getResource("org/embl/ebi/escience/scuflui/icons/explorer/unknownprocessor.png"));
            Enumeration<URL> en = loader.getResources("taverna.properties");
            tavernaProperties = new Properties();
            while (en.hasMoreElements()) {
                URL resourceURL = en.nextElement();
                LOG.warn((Object)("Loading resources from : " + resourceURL.toString()));
                tavernaProperties.load(resourceURL.openStream());
            }
            Iterator<Object> i = tavernaProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                LOG.debug((Object)("key: " + key));
                String value = tavernaProperties.getProperty(key);
                LOG.debug((Object)("\t value: " + value));
                String[] keyElements = key.split("\\.");
                if (keyElements.length == 4 && keyElements[1].equals("processor")) {
                    String tagName = keyElements[2];
                    LOG.debug((Object)("\ttag name: " + tagName));
                    if (keyElements[3].equals("class")) {
                        tagNameForClassName.put(value, tagName);
                        classNameForTagName.put(tagName, value);
                    } else if (keyElements[3].equals("colour")) {
                        coloursForTagName.put(tagName, value);
                    } else if (keyElements[3].equals("taskclass")) {
                        taskClassForTagName.put(tagName, value);
                    } else if (keyElements[3].equals("xml")) {
                        String handlerClassName = value;
                        Class<?> handlerClass = Class.forName(handlerClassName);
                        XMLHandler xh = (XMLHandler)handlerClass.newInstance();
                        xmlHandlerForTagName.put(tagName, xh);
                    } else if (keyElements[3].equals("editor")) {
                        String editorClassName = value;
                        Class<?> editorClass = Class.forName(editorClassName);
                        ProcessorEditor pe = (ProcessorEditor)editorClass.newInstance();
                        editorForTagName.put(tagName, pe);
                    }
                }
                if ((keyElements = key.split("\\.", 3)).length != 3 || !keyElements[1].equals("scavenger")) continue;
                String scavengerClassName = keyElements[2];
                String scavengerTagName = value;
                Object o = Class.forName(scavengerClassName).newInstance();
                if (o instanceof ScavengerHelper) {
                    tagNameForScavenger.put(scavengerClassName, scavengerTagName);
                    continue;
                }
                if (!(o instanceof Scavenger)) continue;
                simpleScavengers.add(o);
            }
            LOG.debug((Object)("Populated xmlHanderForTagName: " + xmlHandlerForTagName));
        }
        catch (Exception e) {
            System.out.println("Error during initialisation for taverna properties! : " + e.getMessage());
            e.printStackTrace();
        }
    }
}

