/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.workbench;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerRenderer;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.dnd.FactorySpecFragment;
import org.embl.ebi.escience.scuflui.dnd.ProcessorSpecFragment;
import org.embl.ebi.escience.scuflui.dnd.SpecFragmentTransferable;
import org.embl.ebi.escience.scuflui.workbench.Scavenger;
import org.embl.ebi.escience.scuflui.workbench.ScavengerCreationException;
import org.embl.ebi.escience.scuflui.workbench.ScavengerTreePopupHandler;
import org.embl.ebi.escience.scuflui.workbench.ScavengerTreeRenderer;
import org.embl.ebi.escience.scuflui.workbench.WebScavenger;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyProcessor;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyScavenger;
import org.embl.ebi.escience.scuflworkers.seqhound.SeqhoundScavenger;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabProcessor;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabScavenger;
import org.embl.ebi.escience.scuflworkers.talisman.TalismanProcessor;
import org.embl.ebi.escience.scuflworkers.talisman.TalismanScavenger;
import org.embl.ebi.escience.scuflworkers.wsdl.WSDLBasedProcessor;
import org.embl.ebi.escience.scuflworkers.wsdl.WSDLBasedScavenger;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class ScavengerTree
extends JTree
implements ScuflUIComponent,
DragSourceListener,
DragGestureListener,
DropTargetListener {
    ScuflModel model = null;
    DefaultMutableTreeNode root = null;
    DefaultTreeModel treeModel = null;
    ArrayList scavengerList = null;
    private int count = 0;
    String biomobyDefaultURLList;
    String soaplabDefaultURLList;
    String wsdlURLList = System.getProperty("taverna.defaultwsdl");
    String webURLList;

    public int getNextCount() {
        return this.count++;
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        DefaultMutableTreeNode node;
        Object userObject;
        Point l = e.getDragOrigin();
        TreePath dragSourcePath = this.getPathForLocation((int)l.getX(), (int)l.getY());
        if (dragSourcePath != null && (userObject = (node = (DefaultMutableTreeNode)dragSourcePath.getLastPathComponent()).getUserObject()) instanceof ProcessorFactory) {
            Element el = ((ProcessorFactory)userObject).getXMLFragment();
            FactorySpecFragment fsf = new FactorySpecFragment(el, node.toString());
            SpecFragmentTransferable t = new SpecFragmentTransferable(fsf);
            e.startDrag(DragSource.DefaultCopyDrop, t, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        try {
            DataFlavor f = SpecFragmentTransferable.processorSpecFragmentFlavor;
            Transferable t = e.getTransferable();
            if (e.isDataFlavorSupported(f)) {
                ProcessorSpecFragment psf = (ProcessorSpecFragment)t.getTransferData(f);
                XMLOutputter xo = new XMLOutputter();
                String searchString = xo.outputString(psf.getElement());
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
                Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
                while (en.hasMoreElements()) {
                    String compare;
                    DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)en.nextElement();
                    Object o = theNode.getUserObject();
                    if (!(o instanceof ProcessorFactory) || !searchString.equals(compare = xo.outputString(((ProcessorFactory)o).getXMLFragment()))) continue;
                    String selectedProcessorString = theNode.getUserObject().toString().toLowerCase();
                    TreePath path = new TreePath(this.treeModel.getPathToRoot(theNode));
                    this.setAllNodesCollapsed();
                    ScuflModelExplorerRenderer r = (ScuflModelExplorerRenderer)this.getCellRenderer();
                    r.setPattern(selectedProcessorString);
                    this.makeVisible(path);
                }
            }
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public ScavengerTree() {
        this(true);
    }

    public ScavengerTree(boolean populate) {
        this.soaplabDefaultURLList = System.getProperty("taverna.defaultsoaplab");
        this.biomobyDefaultURLList = System.getProperty("taverna.defaultbiomoby");
        this.webURLList = System.getProperty("taverna.defaultweb");
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this);
        this.scavengerList = new ArrayList();
        this.root = new DefaultMutableTreeNode("Available Processors");
        this.treeModel = (DefaultTreeModel)this.getModel();
        this.treeModel.setRoot(this.root);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.getSelectionModel().setSelectionMode(1);
        ScavengerTreeRenderer renderer = new ScavengerTreeRenderer();
        this.setCellRenderer(renderer);
        this.addMouseListener(new ScavengerTreePopupHandler(this));
        if (populate) {
            Set simpleScavengers = ProcessorHelper.getSimpleScavengerSet();
            if (!simpleScavengers.isEmpty()) {
                DefaultMutableTreeNode t = new DefaultMutableTreeNode("Local Services");
                this.treeModel.insertNodeInto(t, (MutableTreeNode)this.treeModel.getRoot(), this.treeModel.getChildCount(this.treeModel.getRoot()));
                Iterator i = simpleScavengers.iterator();
                while (i.hasNext()) {
                    Scavenger s = (Scavenger)i.next();
                    this.treeModel.insertNodeInto(s, t, this.treeModel.getChildCount(t));
                }
            }
            new DefaultScavengerLoaderThread(this);
        } else {
            this.expandPath(new TreePath(this.root));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodesExpanded() {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            this.expandAll(this, new TreePath(this.root), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodesCollapsed() {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            this.expandAll(this, new TreePath(this.root), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0 && !(((DefaultMutableTreeNode)node).getUserObject() instanceof Processor)) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
    }

    public void addScavengersFromModel() throws ScavengerCreationException {
        if (this.model != null) {
            String mobyCentralLocation;
            String wsdlLocation;
            HashMap wsdlLocations = new HashMap();
            HashMap talismanLocations = new HashMap();
            HashMap soaplabInstallations = new HashMap();
            HashSet<String> biomobyCentralLocations = new HashSet<String>();
            Processor[] p = this.model.getProcessors();
            for (int i = 0; i < p.length; ++i) {
                if (p[i] instanceof WSDLBasedProcessor) {
                    wsdlLocation = ((WSDLBasedProcessor)p[i]).getWSDLLocation();
                    wsdlLocations.put(wsdlLocation, null);
                    continue;
                }
                if (p[i] instanceof TalismanProcessor) {
                    String tscriptLocation = ((TalismanProcessor)p[i]).getTScriptURL();
                    talismanLocations.put(tscriptLocation, null);
                    continue;
                }
                if (p[i] instanceof SoaplabProcessor) {
                    String endpoint = ((SoaplabProcessor)p[i]).getEndpoint().toString();
                    String[] parts = endpoint.split("/");
                    String base = "";
                    for (int j = 0; j < parts.length - 1; ++j) {
                        base = base + parts[j] + "/";
                    }
                    soaplabInstallations.put(base, null);
                    continue;
                }
                if (!(p[i] instanceof BiomobyProcessor)) continue;
                mobyCentralLocation = ((BiomobyProcessor)p[i]).getMobyEndpoint();
                biomobyCentralLocations.add(mobyCentralLocation);
            }
            Iterator<Object> i = wsdlLocations.keySet().iterator();
            while (i.hasNext()) {
                wsdlLocation = (String)i.next();
                this.addScavenger(new WSDLBasedScavenger(wsdlLocation));
            }
            i = talismanLocations.keySet().iterator();
            while (i.hasNext()) {
                String tscriptURL = (String)i.next();
                this.addScavenger(new TalismanScavenger(tscriptURL));
            }
            i = soaplabInstallations.keySet().iterator();
            while (i.hasNext()) {
                String base = (String)i.next();
                this.addScavenger(new SoaplabScavenger(base));
            }
            i = biomobyCentralLocations.iterator();
            while (i.hasNext()) {
                mobyCentralLocation = (String)i.next();
                this.addScavenger(new BiomobyScavenger(mobyCentralLocation));
            }
        }
    }

    public synchronized void addScavenger(Scavenger theScavenger) {
        String newName = theScavenger.getUserObject().toString();
        Iterator i = this.scavengerList.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.equals(newName)) continue;
            return;
        }
        this.scavengerList.add(theScavenger.getUserObject().toString());
        this.treeModel.insertNodeInto(theScavenger, (MutableTreeNode)this.treeModel.getRoot(), this.treeModel.getChildCount(this.treeModel.getRoot()));
        TreePath path = new TreePath(this.root);
        this.expandPath(path);
    }

    public void attachToModel(ScuflModel theModel) {
        this.model = theModel;
    }

    public void detachFromModel() {
        this.model = null;
    }

    public String getName() {
        return "Available services";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowScavenger;
    }

    class DefaultScavengerLoaderThread
    extends Thread {
        ScavengerTree scavengerTree;

        public DefaultScavengerLoaderThread(ScavengerTree scavengerTree) {
            this.scavengerTree = scavengerTree;
            this.start();
        }

        public void run() {
            int i;
            String[] urls;
            if (ScavengerTree.this.webURLList != null) {
                urls = ScavengerTree.this.webURLList.split("\\s*,\\s*");
                for (i = 0; i < urls.length; ++i) {
                    try {
                        this.scavengerTree.addScavenger(new WebScavenger(urls[i], (DefaultTreeModel)this.scavengerTree.getModel()));
                        continue;
                    }
                    catch (ScavengerCreationException sce) {
                        sce.printStackTrace();
                    }
                }
            }
            if (ScavengerTree.this.wsdlURLList != null) {
                urls = ScavengerTree.this.wsdlURLList.split("\\s*,\\s*");
                for (i = 0; i < urls.length; ++i) {
                    try {
                        this.scavengerTree.addScavenger(new WSDLBasedScavenger(urls[i]));
                        continue;
                    }
                    catch (ScavengerCreationException sce) {
                        sce.printStackTrace();
                    }
                }
            }
            if (ScavengerTree.this.soaplabDefaultURLList != null) {
                urls = ScavengerTree.this.soaplabDefaultURLList.split("\\s*,\\s*");
                for (i = 0; i < urls.length; ++i) {
                    try {
                        System.out.println("Creating soaplab scavenger : '" + urls[i] + "'");
                        this.scavengerTree.addScavenger(new SoaplabScavenger(urls[i]));
                        continue;
                    }
                    catch (ScavengerCreationException sce) {
                        sce.printStackTrace();
                    }
                }
            }
            if (ScavengerTree.this.biomobyDefaultURLList != null) {
                urls = ScavengerTree.this.biomobyDefaultURLList.split("\\s*,\\s*");
                for (i = 0; i < urls.length; ++i) {
                    try {
                        System.out.println("Creating biomoby scavenger : '" + urls[i] + "'");
                        this.scavengerTree.addScavenger(new BiomobyScavenger(urls[i]));
                        continue;
                    }
                    catch (ScavengerCreationException sce) {
                        sce.printStackTrace();
                    }
                }
            }
            try {
                this.scavengerTree.addScavenger(new SeqhoundScavenger());
            }
            catch (ScavengerCreationException sce) {
                sce.printStackTrace();
            }
            this.scavengerTree.setAllNodesExpanded();
        }
    }
}

