/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.workbench;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public FileDrop(Component c, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component c, boolean recursive, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(PrintStream out, Component c, boolean recursive, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(Component c, Border dragBorder, Listener listener) {
        this(null, c, dragBorder, false, listener);
    }

    public FileDrop(Component c, Border dragBorder, boolean recursive, Listener listener) {
        this(null, c, dragBorder, recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Border dragBorder, Listener listener) {
        this(out, c, dragBorder, false, listener);
    }

    public FileDrop(final PrintStream out, final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            FileDrop.this.normalBorder = jc.getBorder();
                            FileDrop.log(out, "FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            FileDrop.log(out, "FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }

                public void dragOver(DropTargetDragEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void drop(DropTargetDropEvent evt) {
                    FileDrop.log(out, "FileDrop: drop event.");
                    try {
                        try {
                            Transferable tr = evt.getTransferable();
                            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                evt.acceptDrop(1);
                                FileDrop.log(out, "FileDrop: file list accepted.");
                                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                                Iterator iterator = fileList.iterator();
                                File[] filesTemp = new File[fileList.size()];
                                fileList.toArray(filesTemp);
                                File[] files = filesTemp;
                                if (listener != null) {
                                    listener.filesDropped(files);
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                FileDrop.log(out, "FileDrop: drop complete.");
                            }
                            FileDrop.log(out, "FileDrop: not a file list - abort.");
                            evt.rejectDrop();
                        }
                        catch (IOException io) {
                            FileDrop.log(out, "FileDrop: IOException - abort:");
                            io.printStackTrace(out);
                            evt.rejectDrop();
                            Object var8_10 = null;
                            if (!(c instanceof JComponent)) return;
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(out, "FileDrop: normal border restored.");
                            return;
                        }
                        catch (UnsupportedFlavorException ufe) {
                            FileDrop.log(out, "FileDrop: UnsupportedFlavorException - abort:");
                            ufe.printStackTrace(out);
                            evt.rejectDrop();
                            Object var8_11 = null;
                            if (!(c instanceof JComponent)) return;
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(out, "FileDrop: normal border restored.");
                            return;
                        }
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (!(c instanceof JComponent)) throw throwable;
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(out, "FileDrop: normal border restored.");
                        throw throwable;
                    }
                    if (!(c instanceof JComponent)) return;
                    JComponent jc = (JComponent)c;
                    jc.setBorder(FileDrop.this.normalBorder);
                    FileDrop.log(out, "FileDrop: normal border restored.");
                }

                public void dragExit(DropTargetEvent evt) {
                    FileDrop.log(out, "FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(out, "FileDrop: normal border restored.");
                    }
                }

                public void dropActionChanged(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(out, c, recursive);
        } else {
            FileDrop.log(out, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support = false;
            try {
                Class<?> arbitraryDndClass = Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            supportsDnD = new Boolean(support);
        }
        return supportsDnD;
    }

    private void makeDropTarget(final PrintStream out, final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            FileDrop.log(out, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent evt) {
                FileDrop.log(out, "FileDrop: Hierarchy changed.");
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                    FileDrop.log(out, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                    FileDrop.log(out, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(out, comps[i], recursive);
            }
        }
    }

    private boolean isDragOk(PrintStream out, DropTargetDragEvent evt) {
        int i;
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (i = 0; !ok && i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            ok = true;
        }
        if (out != null) {
            if (flavors.length == 0) {
                FileDrop.log(out, "FileDrop: no data flavors.");
            }
            for (i = 0; i < flavors.length; ++i) {
                FileDrop.log(out, flavors[i].toString());
            }
        }
        return ok;
    }

    private static void log(PrintStream out, String message) {
        if (out != null) {
            out.println(message);
        }
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(null, c, true);
    }

    public static boolean remove(PrintStream out, Component c, boolean recursive) {
        if (FileDrop.supportsDnD()) {
            FileDrop.log(out, "FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                Component[] comps = ((Container)c).getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    FileDrop.remove(out, comps[i], recursive);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("FileDrop");
        final JTextArea text = new JTextArea();
        frame.getContentPane().add((Component)new JScrollPane(text), "Center");
        new FileDrop(System.out, text, new Listener(){

            public void filesDropped(File[] files) {
                for (int i = 0; i < files.length; ++i) {
                    try {
                        text.append(files[i].getCanonicalPath() + "\n");
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        frame.setBounds(100, 100, 300, 400);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

