/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveSPI;

public class SaveToFileSystemMappingLSIDs
implements ResultMapSaveSPI {
    static char sep = (char)47;

    public Icon getIcon() {
        return ScuflIcons.saveIcon;
    }

    public String getDescription() {
        return "Saves the complete set of results to the file system,\nwriting each result into its own file or set of directories\nin the case of collections, the directory structure\nmirroring that of the collection and leaf nodes being\nallocated numbers as names starting at zero and incrementing.\nQuoted (\") LSIDs of outputs are replaced with relative file-names.\n";
    }

    public String getName() {
        return "Save to disk as website";
    }

    public ActionListener getListener(Map results, JComponent parent) {
        final Map resultMap = results;
        final JComponent parentComponent = parent;
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataThing resultValue;
                String resultName;
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(1);
                int returnVal = jfc.showSaveDialog(parentComponent);
                HashMap fileNames = new HashMap();
                Iterator i = resultMap.keySet().iterator();
                while (i.hasNext()) {
                    resultName = (String)i.next();
                    resultValue = (DataThing)resultMap.get(resultName);
                    try {
                        SaveToFileSystemMappingLSIDs.guessFileNames(fileNames, resultName, resultValue);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(parentComponent, "Problem saving results : \n" + ioe.getMessage(), "Error!", 0);
                    }
                }
                i = resultMap.keySet().iterator();
                while (i.hasNext()) {
                    resultName = (String)i.next();
                    resultValue = (DataThing)resultMap.get(resultName);
                    try {
                        if (returnVal != 0) continue;
                        File f = jfc.getSelectedFile();
                        String name = resultName;
                        DataThing mappedResultValue = SaveToFileSystemMappingLSIDs.this.mapLSIDs(fileNames, resultValue);
                        mappedResultValue.writeToFileSystem(f, name);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(parentComponent, "Problem saving results : \n" + ioe.getMessage(), "Error!", 0);
                    }
                }
            }
        };
    }

    protected static void guessFileNames(Map fileNames, String resultName, DataThing resultValue) throws IOException {
        String defaultExtension = ".text";
        String syntacticType = resultValue.getSyntacticType().split("'")[1].toLowerCase();
        if (syntacticType.matches(".*text/xml.*")) {
            defaultExtension = ".xml";
        } else if (syntacticType.matches(".*text/html.*")) {
            defaultExtension = ".html";
        } else if (syntacticType.matches(".*text/rtf.*")) {
            defaultExtension = ".rtf";
        } else if (syntacticType.matches(".*image/png.*")) {
            defaultExtension = ".png";
        } else if (syntacticType.matches(".*image/jpeg.*")) {
            defaultExtension = ".jpeg";
        } else if (syntacticType.matches(".*image/gif.*")) {
            defaultExtension = ".gif";
        } else if (syntacticType.matches(".*x-graphviz.*")) {
            defaultExtension = ".dot.text";
        }
        SaveToFileSystemMappingLSIDs.guessFileNames(fileNames, resultName, resultValue, resultValue.getDataObject(), defaultExtension);
    }

    protected static void guessFileNames(Map fileNames, String name, DataThing resultValue, Object o, String defaultExtension) throws IOException {
        String lsid = resultValue.getLSID(o);
        if (o instanceof Collection) {
            if (lsid != null && lsid.length() > 0) {
                fileNames.put(lsid, name + sep);
            }
            int count = 0;
            Collection c = (Collection)o;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                SaveToFileSystemMappingLSIDs.guessFileNames(fileNames, name + sep + count++, resultValue, i.next(), defaultExtension);
            }
        } else {
            if (o instanceof String && defaultExtension == null) {
                name = name + ".text";
            } else if (defaultExtension != null) {
                name = name + defaultExtension;
            }
            if (lsid != null && lsid.length() > 0) {
                fileNames.put(lsid, name);
            }
        }
    }

    protected DataThing mapLSIDs(Map fileNames, DataThing value) {
        Object newValue = this.replaceLSIDsInDataThingValues(fileNames, value, value.getDataObject(), 0);
        DataThing newdt = new DataThing(newValue);
        try {
            SemanticMarkup markup = value.getMetadata();
            newdt.copyMetadataFrom(value);
            if (markup != null) {
                SemanticMarkup newMarkup = newdt.getMetadata();
                if (markup.getSemanticType() != null) {
                    newMarkup.setSemanticType(markup.getSemanticType());
                }
                String[] mimeTypes = markup.getMIMETypes();
                for (int i = 0; mimeTypes != null && i < mimeTypes.length; ++i) {
                    newMarkup.addMIMEType(mimeTypes[i]);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR copying semantic markup while mapping lsids: " + e);
            e.printStackTrace(System.err);
        }
        return newdt;
    }

    private Object replaceLSIDsInDataThingValues(Map fileNames, DataThing dt, Object value, int depth) {
        ArrayList<Object> newValue = value;
        if (value instanceof String) {
            String asString = (String)((Object)value);
            int index = asString.indexOf("\"urn:lsid:");
            if (index < 0) {
                return value;
            }
            StringBuffer buffer = new StringBuffer((String)((Object)value));
            while (index >= 0) {
                int from = index + 1;
                int len = "urn:lsid:".length();
                while (from + len < buffer.length() && (Character.isLetterOrDigit(buffer.charAt(from + len)) || buffer.charAt(from + len) == ':' || buffer.charAt(from + len) == '.')) {
                    ++len;
                }
                String lsid = buffer.substring(from, from + len);
                String filename = (String)fileNames.get(lsid);
                if (filename == null) {
                    System.err.println("WARNING: unknown filename for " + lsid);
                } else {
                    buffer.replace(from, from + len, filename);
                    for (int di = 0; di < depth; ++di) {
                        buffer.insert(from, "../");
                    }
                }
                index = buffer.indexOf("\"urn:lsid:", index + 1);
            }
            newValue = buffer.toString();
        } else {
            if (value instanceof byte[] || value instanceof byte[][]) {
                return value;
            }
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(value, i, this.replaceLSIDsInDataThingValues(fileNames, dt, Array.get(value, i), depth + 1));
                }
            } else if (value instanceof List) {
                ArrayList<Object> newList = new ArrayList<Object>((List)value);
                for (int i = 0; i < newList.size(); ++i) {
                    newList.set(i, this.replaceLSIDsInDataThingValues(fileNames, dt, newList.get(i), depth + 1));
                }
                newValue = newList;
            } else {
                System.err.println("MapLSIDs ignoring a " + value.getClass().getName() + " - sorry");
            }
        }
        if (newValue != value) {
            dt.setLSID(newValue, dt.getLSID(value));
        }
        return newValue;
    }
}

