/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveSPI;

public class SaveToFileSystem
implements ResultMapSaveSPI {
    public Icon getIcon() {
        return ScuflIcons.saveIcon;
    }

    public String getDescription() {
        return "Saves the complete set of results to the file system,\nwriting each result into its own file or set of directories\nin the case of collections, the directory structure\nmirroring that of the collection and leaf nodes being\nallocated numbers as names starting at zero and incrementing.";
    }

    public String getName() {
        return "Save to disk";
    }

    public ActionListener getListener(Map results, JComponent parent) {
        final Map resultMap = results;
        final JComponent parentComponent = parent;
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(1);
                int returnVal = jfc.showSaveDialog(parentComponent);
                Iterator i = resultMap.keySet().iterator();
                while (i.hasNext()) {
                    String resultName = (String)i.next();
                    DataThing resultValue = (DataThing)resultMap.get(resultName);
                    try {
                        if (returnVal != 0) continue;
                        File f = jfc.getSelectedFile();
                        String name = resultName;
                        resultValue.writeToFileSystem(f, name);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(parentComponent, "Problem saving results : \n" + ioe.getMessage(), "Error!", 0);
                    }
                }
            }
        };
    }
}

