/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.renderers;

import cht.svista.SeqVISTA;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.renderers.AbstractRenderer;
import org.embl.ebi.escience.scuflui.renderers.RendererException;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;

public class SeqVistaRenderer
extends AbstractRenderer.ByMimeType {
    private String seqType = "fasta";
    private int np = 0;

    public SeqVistaRenderer() {
        super("SeqVista");
    }

    public boolean isTerminal() {
        return true;
    }

    public boolean canHandle(RendererRegistry renderers, Object userObject, String mimeType) {
        if (mimeType.matches(".*chemical/x-swissprot.*")) {
            this.seqType = "embl";
            this.np = 2;
            return true;
        }
        if (mimeType.matches(".*chemical/x-embl-dl-nucleotide.*")) {
            this.seqType = "embl";
            this.np = 1;
            return true;
        }
        if (mimeType.matches(".*chemical/x-fasta.*")) {
            this.seqType = "fasta";
            this.np = 0;
            return true;
        }
        if (mimeType.matches(".*chemical/x-ppd.*")) {
            this.seqType = "ppd";
            return true;
        }
        return false;
    }

    public JComponent getComponent(RendererRegistry renderers, DataThing dataThing) throws RendererException {
        SeqVISTA vista = new SeqVISTA(){

            public Dimension getPreferredSize() {
                return new Dimension(100, 100);
            }
        };
        try {
            System.out.println((String)dataThing.getDataObject());
            System.out.println(this.seqType);
            vista.loadFromText((String)dataThing.getDataObject(), false, this.seqType, this.np);
            return vista;
        }
        catch (Exception ex) {
            RendererException re = new RendererException("Unable to launch seqvista!");
            re.initCause(ex);
            throw re;
        }
    }
}

