/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.facets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class PropertySheet
extends JPanel {
    private static Logger LOG = Logger.getLogger((Class)PropertySheet.class);

    public PropertySheet(final Object bean) {
        LOG.info((Object)("Creating property sheet for bean " + bean.getClass().getName()));
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints lhc = new GridBagConstraints();
            GridBagConstraints rhc = new GridBagConstraints();
            lhc.gridx = 0;
            rhc.gridx = 1;
            lhc.gridy = 0;
            rhc.gridy = 0;
            lhc.anchor = 13;
            rhc.anchor = 17;
            rhc.fill = 1;
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                final PropertyDescriptor pd = props[i];
                Method read = pd.getReadMethod();
                final Method write = pd.getWriteMethod();
                LOG.info((Object)("Property: " + pd.getName()));
                if (read == null || write == null) continue;
                LOG.info((Object)"mutable");
                Class<?> propType = read.getReturnType();
                LOG.info((Object)("of type: " + propType.getName()));
                final PropertyEditor pe = PropertyEditorManager.findEditor(propType);
                if (pe == null) {
                    LOG.info((Object)"no property editor");
                    continue;
                }
                LOG.info((Object)("got editor: " + pe));
                pe.setValue(read.invoke(bean, new Object[0]));
                if (pe.supportsCustomEditor()) {
                    LOG.info((Object)"custom editor");
                    Component cmp = pe.getCustomEditor();
                    if (cmp == null) continue;
                    LOG.info((Object)"got editor comopnent");
                    this.add((Component)new JLabel(pd.getDisplayName()), lhc);
                    this.add(cmp, rhc);
                    ++lhc.gridy;
                    ++rhc.gridy;
                    pe.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            PropertySheet.this.update(write, bean, pe, pd);
                        }
                    });
                    continue;
                }
                if (pe.isPaintable()) {
                    LOG.info((Object)"Paintable - ignoring for now");
                    continue;
                }
                String[] vals = pe.getTags();
                if (vals != null) {
                    LOG.info((Object)"One of several options");
                    final JComboBox<String> options = new JComboBox<String>(vals);
                    options.setSelectedItem(pe.getAsText());
                    options.setEditable(false);
                    options.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent ie) {
                            pe.setAsText((String)options.getSelectedItem());
                            PropertySheet.this.update(write, bean, pe, pd);
                        }
                    });
                    this.add((Component)new JLabel(pd.getDisplayName()), lhc);
                    this.add(options, rhc);
                    ++lhc.gridy;
                    ++rhc.gridy;
                    continue;
                }
                LOG.info((Object)"Text input");
                final JTextField input = new JTextField(pe.getAsText());
                input.setEditable(true);
                final Color original = input.getBackground();
                input.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        LOG.info((Object)("property: " + evt.getPropertyName() + " " + evt.getNewValue()));
                    }
                });
                input.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        pe.setAsText(input.getText());
                        input.setBackground(original);
                        PropertySheet.this.update(write, bean, pe, pd);
                    }
                });
                input.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        Document doc = input.getDocument();
                        try {
                            input.setText(doc.getText(0, doc.getLength()));
                            LOG.info((Object)("focus lost. set text to " + input.getText()));
                        }
                        catch (BadLocationException ble) {
                            LOG.error((Object)ble);
                        }
                    }
                });
                this.add((Component)new JLabel(pd.getDisplayName()), lhc);
                this.add((Component)input, rhc);
                ++lhc.gridy;
                ++rhc.gridy;
            }
        }
        catch (Exception e) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Unable to edit bean"), "Center");
        }
    }

    private void update(Method write, Object bean, PropertyEditor pe, PropertyDescriptor pd) {
        try {
            LOG.info((Object)("update " + pd.getDisplayName() + " to " + pe.getValue()));
            write.invoke(bean, pe.getValue());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Unable to set property " + pd.getDisplayName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("Unable to set property " + pd.getDisplayName()), (Throwable)e);
        }
    }

    public static class Editor
    extends PropertyEditorSupport {
        final JPanel child;

        public Editor() {
            LOG.info((Object)"Creating new PropertySheet.Editor");
            this.child = new JPanel();
            this.child.setLayout(new BorderLayout());
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return this.child;
        }

        public void setValue(Object value) {
            super.setValue(value);
            LOG.info((Object)("Seting value in PropertySheet.Editor to " + value));
            this.child.removeAll();
            this.child.add((Component)new PropertySheet(value), "Center");
        }
    }
}

