/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.view.XScuflView;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class XScuflTextArea
extends JTextArea
implements ScuflModelEventListener,
ScuflUIComponent {
    private XScuflView xscufl = null;
    private ScuflModel model = null;
    private int updateStatus = 0;

    public XScuflTextArea() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
    }

    public void attachToModel(ScuflModel model) {
        if (this.model == null) {
            this.xscufl = new XScuflView(model);
            model.addListener(this);
            this.updateText();
        }
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model.removeListener(this.xscufl);
            this.model = null;
            this.xscufl = null;
            this.updateText();
        }
    }

    private void updateText() {
        if (this.xscufl != null) {
            this.setText(this.xscufl.getXMLText());
        } else {
            this.setText(null);
        }
        this.repaint();
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        if (this.updateStatus == 0) {
            this.updateStatus = 1;
            while (this.updateStatus != 0) {
                this.updateText();
                if (this.updateStatus == 2) {
                    this.updateStatus = 1;
                    continue;
                }
                this.updateStatus = 0;
            }
        } else {
            this.updateStatus = 2;
        }
    }

    public ImageIcon getIcon() {
        return ScuflIcons.xmlNodeIcon;
    }

    public String getName() {
        return "Workflow XML preview";
    }
}

