/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scuflui.ScuflIcons;

class WorkflowInputPanel
extends JPanel {
    Port underlyingPort;
    JTextArea textArea;
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$EnactorLaunchPanel;

    public WorkflowInputPanel(Port p) {
        JTextArea text;
        this.setLayout(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), p.getName() + " - " + p.getSyntacticType());
        this.setBorder(border);
        this.textArea = text = new JTextArea("Enter input value here");
        text.setWrapStyleWord(true);
        JScrollPane pane = new JScrollPane(text);
        pane.setPreferredSize(new Dimension(100, 100));
        this.add((Component)pane, "Center");
        JButton loadFromFile = new JButton(ScuflIcons.openIcon);
        loadFromFile.setPreferredSize(new Dimension(32, 32));
        JButton loadFromURL = new JButton(ScuflIcons.webIcon);
        loadFromURL.setPreferredSize(new Dimension(32, 32));
        JButton clear = new JButton(ScuflIcons.deleteIcon);
        clear.setPreferredSize(new Dimension(32, 32));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.add(clear);
        buttonPanel.add(loadFromFile);
        buttonPanel.add(loadFromURL);
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                text.setText("");
            }
        });
        final JFileChooser fc = new JFileChooser();
        loadFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$EnactorLaunchPanel == null ? (class$org$embl$ebi$escience$scuflui$EnactorLaunchPanel = WorkflowInputPanel.class$("org.embl.ebi.escience.scuflui.EnactorLaunchPanel")) : class$org$embl$ebi$escience$scuflui$EnactorLaunchPanel);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    fc.setCurrentDirectory(new File(curDir));
                    int returnVal = fc.showOpenDialog(WorkflowInputPanel.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", fc.getCurrentDirectory().toString());
                        File file = fc.getSelectedFile();
                        InputStream is = file.toURL().openStream();
                        BufferedReader dis = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
                        StringBuffer sb = new StringBuffer();
                        String s = null;
                        while ((s = dis.readLine()) != null) {
                            sb.append(s);
                            sb.append("\n");
                        }
                        text.setText(sb.toString());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                }
            }
        });
        loadFromURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String name = (String)JOptionPane.showInputDialog(null, "URL to open?", "URL Required", 3, null, null, "http://");
                    if (name != null) {
                        InputStream is = new URL(name).openStream();
                        BufferedReader dis = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
                        StringBuffer sb = new StringBuffer();
                        String s = null;
                        while ((s = dis.readLine()) != null) {
                            sb.append(s);
                            sb.append("\n");
                        }
                        text.setText(sb.toString());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                }
            }
        });
        this.add((Component)buttonPanel, "East");
        this.underlyingPort = p;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getName() {
        return this.underlyingPort.getName();
    }

    public Port getPort() {
        return this.underlyingPort;
    }
}

