/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scufl.semantics.RDFSClassHolder;
import org.embl.ebi.escience.scufl.semantics.RDFSParser;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class ScuflSemanticMarkupEditor
extends JPanel
implements ScuflUIComponent {
    private final SemanticMarkup theMetadata;

    public ScuflSemanticMarkupEditor(SemanticMarkup m) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 100));
        this.setLayout(new BoxLayout(this, 3));
        JTabbedPane tabbedPane = new JTabbedPane();
        this.add(tabbedPane);
        this.theMetadata = m;
        JPanel ontologyPanel = new JPanel(new BorderLayout());
        ontologyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Pick from ontology"));
        ontologyPanel.setPreferredSize(new Dimension(400, 400));
        final DefaultTreeModel treeModel = new DefaultTreeModel(RDFSParser.rootNode);
        final JTree ontologyTree = new JTree(treeModel);
        ontologyTree.setCellRenderer(this.getRenderer(null));
        JScrollPane ontologyTreeDisplayPane = new JScrollPane(ontologyTree);
        ontologyPanel.add((Component)ontologyTreeDisplayPane, "Center");
        final JTextField selectedOntologyNode = new JTextField(this.theMetadata.getSemanticType());
        ontologyPanel.add((Component)selectedOntologyNode, "South");
        JPanel currentTermPanel = new JPanel(new GridLayout(2, 0));
        currentTermPanel.add(new JLabel("Select from ontology or manually edit term below"));
        currentTermPanel.add(selectedOntologyNode);
        if (!this.theMetadata.getSemanticType().equals("")) {
            String filterString = this.theMetadata.getSemanticType();
            String[] filter = this.theMetadata.getSemanticType().split("#");
            if (filter.length == 2) {
                filterString = filter[1];
            }
            ontologyTree.setCellRenderer(this.getRenderer(filterString));
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)en.nextElement();
                if (!theNode.getUserObject().toString().toLowerCase().matches(filterString)) continue;
                TreePath path = new TreePath(treeModel.getPathToRoot(theNode));
                ontologyTree.makeVisible(path);
            }
        }
        ontologyPanel.add((Component)currentTermPanel, "South");
        ontologyTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ontologyTree.getLastSelectedPathComponent();
                if (node != null) {
                    try {
                        RDFSClassHolder h = (RDFSClassHolder)node.getUserObject();
                        selectedOntologyNode.setText(h.getClassName());
                        ScuflSemanticMarkupEditor.this.theMetadata.setSemanticType(h.getClassName());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        });
        selectedOntologyNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflSemanticMarkupEditor.this.theMetadata.setSemanticType(selectedOntologyNode.getText());
            }
        });
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridLayout(0, 2));
        final JTextField filterText = new JTextField("");
        filterText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String filterString = filterText.getText();
                if (filterString.equals("")) {
                    ontologyTree.setCellRenderer(ScuflSemanticMarkupEditor.this.getRenderer(null));
                } else {
                    ontologyTree.setCellRenderer(ScuflSemanticMarkupEditor.this.getRenderer(filterString));
                }
            }
        });
        JButton showFromFilter = new JButton("Find from regex : ");
        showFromFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String filterString = filterText.getText();
                ScuflSemanticMarkupEditor.this.expandAll(ontologyTree, false);
                if (!filterString.equals("")) {
                    ontologyTree.setCellRenderer(ScuflSemanticMarkupEditor.this.getRenderer(filterString));
                    DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
                    Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
                    while (en.hasMoreElements()) {
                        DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)en.nextElement();
                        if (!theNode.getUserObject().toString().toLowerCase().matches(filterString)) continue;
                        TreePath path = new TreePath(treeModel.getPathToRoot(theNode));
                        ontologyTree.makeVisible(path);
                    }
                }
            }
        });
        filterPanel.add(showFromFilter);
        filterPanel.add(filterText);
        ontologyPanel.add((Component)filterPanel, "North");
        tabbedPane.addTab("Ontology", ontologyPanel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setPreferredSize(new Dimension(400, 400));
        descriptionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Edit Description"));
        final JTextArea descriptionText = new JTextArea(this.theMetadata.getDescription());
        JScrollPane descriptionPane = new JScrollPane(descriptionText);
        descriptionPanel.add((Component)descriptionPane, "Center");
        JButton descriptionUpdateButton = new JButton("Update");
        descriptionUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflSemanticMarkupEditor.this.theMetadata.setDescription(descriptionText.getText());
            }
        });
        descriptionPanel.add((Component)descriptionUpdateButton, "South");
        tabbedPane.addTab("Description", descriptionPanel);
        JPanel topLevelMimePanel = new JPanel(new BorderLayout());
        JPanel mimePanel = new JPanel(new BorderLayout());
        topLevelMimePanel.add((Component)mimePanel, "Center");
        mimePanel.setPreferredSize(new Dimension(400, 400));
        mimePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Current MIME Types"));
        JPanel mimeEditPanel = new JPanel(new BorderLayout());
        mimeEditPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Enter new MIME Type and hit return"));
        topLevelMimePanel.add((Component)mimeEditPanel, "South");
        final JList<String> mimeTypeList = new JList<String>(this.theMetadata.getMIMETypes());
        JScrollPane mimeListPane = new JScrollPane(mimeTypeList);
        mimePanel.add((Component)mimeListPane, "Center");
        final JTextField mimeEntryField = new JTextField();
        mimeEditPanel.add((Component)mimeEntryField, "North");
        JButton clearMimeTypes = new JButton(ScuflIcons.deleteIcon);
        clearMimeTypes.setPreferredSize(new Dimension(32, 32));
        clearMimeTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflSemanticMarkupEditor.this.theMetadata.clearMIMETypes();
                mimeTypeList.setModel(new DefaultListModel());
            }
        });
        mimeEntryField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflSemanticMarkupEditor.this.theMetadata.addMIMEType(mimeEntryField.getText());
                mimeTypeList.setModel(new DefaultListModel());
                String[] types = ScuflSemanticMarkupEditor.this.theMetadata.getMIMETypes();
                for (int i = 0; i < types.length; ++i) {
                    ((DefaultListModel)mimeTypeList.getModel()).add(i, types[i]);
                }
            }
        });
        mimeEditPanel.add((Component)clearMimeTypes, "East");
        tabbedPane.addTab("MIME Types", topLevelMimePanel);
        this.setVisible(true);
    }

    public ImageIcon getIcon() {
        return ScuflIcons.classIcon;
    }

    public void attachToModel(ScuflModel theModel) {
    }

    public void detachFromModel() {
    }

    public String getName() {
        return "Markup editor for " + this.theMetadata.getSubject().toString();
    }

    public TreeCellRenderer getRenderer(String searchRegex) {
        final String searchString = searchRegex;
        return new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof RDFSClassHolder) {
                    if (searchString == null) {
                        this.setIcon(ScuflIcons.classIcon);
                    } else if (userObject.toString().toLowerCase().matches(searchString)) {
                        this.setIcon(ScuflIcons.selectedClassIcon);
                        this.setText("<html><font color=\"red\">" + userObject.toString() + "</font></html>");
                        this.setBackground(new Color(191, 213, 197));
                    } else {
                        this.setIcon(ScuflIcons.classIcon);
                    }
                } else if (expanded) {
                    this.setIcon(ScuflIcons.folderOpenIcon);
                } else {
                    this.setIcon(ScuflIcons.folderClosedIcon);
                }
                return this;
            }
        };
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
}

