/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.view.TreeModelView;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerPopupHandler;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerRenderer;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class ScuflModelExplorer
extends JTree
implements ScuflModelEventListener,
ScuflUIComponent {
    ScuflModel model = null;
    TreeModelView treeModel = new TreeModelView();

    public ScuflModelExplorer() {
        this.setModel(this.treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new ScuflModelExplorerPopupHandler(this));
        this.putClientProperty("JTree.lineStyle", "Angled");
        ScuflModelExplorerRenderer renderer = new ScuflModelExplorerRenderer();
        this.setCellRenderer(renderer);
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowExplorer;
    }

    public void setDefaultExpansionState() {
        this.expandAll(this, new TreePath(this.treeModel.getRoot()), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0 && !(((DefaultMutableTreeNode)node).getUserObject() instanceof Processor)) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                if (((DefaultMutableTreeNode)n).getUserObject() instanceof Processor) continue;
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void attachToModel(ScuflModel theModel) {
        this.model = theModel;
        this.treeModel.attachToModel(theModel);
        theModel.addListener(this.treeModel);
        theModel.addListener(this);
        this.setDefaultExpansionState();
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model.removeListener(this.treeModel);
        }
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        this.setDefaultExpansionState();
    }

    public String getName() {
        return "Scufl Model Explorer";
    }
}

